package com.digiwin.athena.auth.context;


import com.digiwin.athena.auth.metadata.domain.ResourceCondition;
import org.springframework.data.mongodb.core.query.Criteria;

import java.util.List;
import java.util.Map;

public class DataAuthContext {
    private static final ThreadLocal<Map<String, Criteria>> MONGO_CONDITION = new ThreadLocal<>();

    private static final ThreadLocal<Map<String, List<ResourceCondition>>> RESOURCE_CONDITION = new ThreadLocal<>();

    public static void setMongoCondition(Map<String, Criteria> criteria) {
        MONGO_CONDITION.set(criteria);
    }

    public static void removeMongoCondition() {
        MONGO_CONDITION.remove();
    }

    public static Map<String, Criteria> getMongoCondition() {
        return MONGO_CONDITION.get();
    }

    public static void setResourceCondition(Map<String, List<ResourceCondition>> resourceCondition) {
        RESOURCE_CONDITION.set(resourceCondition);
    }

    public static void removeResourceCondition() {
        RESOURCE_CONDITION.remove();
    }

    public static Map<String, List<ResourceCondition>> getResourceCondition() {
        return RESOURCE_CONDITION.get();
    }
}
