package com.digiwin.athena.auth.service;

import com.digiwin.athena.auth.domain.AuthBatchQuery;
import com.digiwin.athena.auth.domain.AuthQueryCondition;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;

import java.util.List;
import java.util.Map;


public interface AuthApiService {

    /**
     * 校验功能权限，支持批量校验，返回结构{resourceId:true}
     */
    Map<String, Boolean> funcAuthVerifyBatch(AuthBatchQuery authBatchQuery);

    /**
     * 校验功能权限，支持单个resourceId多组条件
     */
    Boolean funcAuthVerifySingle(AuthQueryCondition authQueryCondition);

    // 通过查询的拒绝和允许action判断权限
    Boolean verifyAuthByQueryPolicy(List<AuthorityPolicy> policyList, String[] requiredActions, String resourceType, String tenantId);

}
