package com.digiwin.athena.auth.service;

import com.digiwin.athena.auth.domain.GrantAuthParam;
import com.digiwin.athena.auth.domain.QueryAuthParam;
import com.digiwin.athena.auth.metadata.domain.AuthUserInfo;
import com.digiwin.athena.auth.metadata.domain.Authority;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.auth.metadata.domain.ResourceRole;

import java.util.List;
import java.util.Map;

public interface AuthService {

    void grantAuth(GrantAuthParam grantAuthParam);

    void applyForAuth(GrantAuthParam grantAuthParam);

    void auditAuth(GrantAuthParam grantAuthParam);

    void removeAuth(GrantAuthParam grantAuthParam, boolean log);

    List<AuthorityPolicy> queryFuncAuthPolicy(QueryAuthParam queryAuthParam);

    List<ResourceRole> queryResourceRoleUser(String resourceType, String resourceId);

    String getResourceId(String role, String application);

    List<AuthorityPolicy> queryDataAuthPolicy(String userId, String resourceType, String resourceId);

    List<Authority> queryAuthority(String userId, String resourceId);

    List<AuthUserInfo> queryNormalUsers(String resourceType, String resourceId);

    void updateTenantCreator(String userId);

    void initAppMgr();

    List<ResourceRole> sortRoles(List<ResourceRole> tenantRoles, List<ResourceRole> resourceRoles);

    void authVerificationSingleWithoutComb(String resourceType, String resourceId, String[] requiredActions);

    Map<String, Boolean> authVerificationBatch(String resourceType, List<String> resourceIds, String[] requiredActions);

    void grantAuthToAssignment(GrantAuthParam grantAuthParam);

    List<ResourceRole> queryAssignResourceRoleUser(String resourceType, String resourceId, String application, String collection);

    void removeAuth4Assign(GrantAuthParam grantAuthParam, boolean b);

    void removeAllAuth4Assign(GrantAuthParam grantAuthParam, boolean b);

}
