/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.auth.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.auth.domain.AuthBatchQuery;
import com.digiwin.athena.auth.domain.AuthQueryCondition;
import com.digiwin.athena.auth.domain.AuthSingleQuery;
import com.digiwin.athena.auth.domain.QueryAuthParam;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.auth.metadata.enums.AuthModeEnum;
import com.digiwin.athena.auth.metadata.enums.CombineTypeEnum;
import com.digiwin.athena.auth.service.AuthApiService;
import com.digiwin.athena.auth.service.AuthService;
import com.digiwin.athena.auth.service.UserService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AuthApiServiceImpl
implements AuthApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthApiServiceImpl.class);
    @Autowired(required=false)
    @Lazy
    private AuthService authService;
    @Autowired
    @Lazy
    private UserService userService;
    @Value(value="${designer.auth.mode:FORBID}")
    private String authMode;
    @Value(value="${designer.domain:default}")
    private String designerDomain;

    @Override
    public Map<String, Boolean> funcAuthVerifyBatch(AuthBatchQuery authBatchQuery) {
        List policyList;
        List<String> resourceIds = authBatchQuery.getResourceIds();
        String[] requiredActions = authBatchQuery.getRequiredActions();
        String resourceType = authBatchQuery.getResourceType();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (AuthModeEnum.FORBID.name().equals(this.authMode)) {
            return resourceIds.stream().collect(Collectors.toMap(Function.identity(), k -> true));
        }
        if (AuthModeEnum.LOCAL.name().equals(this.authMode)) {
            queryAuthParam = new QueryAuthParam().setUserId(this.userService.getCurrentUser()).setResourceType(resourceType).setResourceId(String.join((CharSequence)";", resourceIds));
            policyList = this.authService.queryFuncAuthPolicy(queryAuthParam);
        } else {
            if (this.userService == null) {
                throw new RuntimeException("\u8bf7\u5b9e\u73b0com.digiwin.athena.auth.service.UserService\u63a5\u53e3");
            }
            queryAuthParam = new QueryAuthParam().setUserId(this.userService.getCurrentUser()).setResourceType(resourceType).setResourceId(String.join((CharSequence)";", resourceIds));
            String response = ((HttpRequest)HttpUtil.createPost((String)(this.designerDomain + "/athena-designer/auth/queryAuthPolicy")).body(JSON.toJSONString((Object)queryAuthParam)).addHeaders(MapUtil.builder((Object)"digi-middleware-auth-user", (Object)this.userService.getToken()).build())).execute().body();
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)response, JSONObject.class);
            Integer code = jsonObject.getInteger("code");
            if (code == 0) {
                JSONArray data = jsonObject.getJSONArray("data");
                policyList = data.toJavaList(AuthorityPolicy.class);
            } else {
                log.error("\u67e5\u8be2\u6743\u9650\u5931\u8d25\uff1a" + response);
                throw new RuntimeException("\u67e5\u8be2\u6743\u9650\u5931\u8d25");
            }
        }
        String tenantId = this.userService.getTenantId();
        resourceIds.forEach(resourceId -> {
            List<AuthorityPolicy> thePolicyList = policyList.stream().filter(policy -> policy.getResourceId() != null && (policy.getResourceId().equals(resourceId) || policy.getResourceId().equals(tenantId))).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(thePolicyList)) {
                Boolean hasAuth = this.verifyAuthByQueryPolicy(thePolicyList, requiredActions, resourceType, tenantId);
                result.put((String)resourceId, hasAuth);
            } else {
                result.put((String)resourceId, false);
            }
        });
        return result;
    }

    @Override
    public Boolean funcAuthVerifySingle(AuthQueryCondition authQueryCondition) {
        CombineTypeEnum combineType = authQueryCondition.getCombineType();
        List<AuthSingleQuery> authSingleQueryList = authQueryCondition.getAuthSingleQueryList();
        switch (combineType) {
            case AND: {
                for (AuthSingleQuery authSingleQuery : authSingleQueryList) {
                    AuthBatchQuery authBatchQuery = new AuthBatchQuery().setResourceIds(Arrays.asList(authSingleQuery.getResourceId())).setRequiredActions(authSingleQuery.getRequiredActions()).setResourceType(authSingleQuery.getResourceType());
                    Map<String, Boolean> authRe = this.funcAuthVerifyBatch(authBatchQuery);
                    if (authRe.get(authSingleQuery.getResourceId()).booleanValue()) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (AuthSingleQuery authSingleQuery : authSingleQueryList) {
                    AuthBatchQuery authBatchQuery = new AuthBatchQuery().setResourceIds(Arrays.asList(authSingleQuery.getResourceId())).setRequiredActions(authSingleQuery.getRequiredActions()).setResourceType(authSingleQuery.getResourceType());
                    Map<String, Boolean> authRe = this.funcAuthVerifyBatch(authBatchQuery);
                    if (!authRe.get(authSingleQuery.getResourceId()).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        }
        log.error("\u6743\u9650\u5165\u53c2\u683c\u5f0f\u4e0d\u5bf9\uff1a" + JSON.toJSONString((Object)authQueryCondition));
        return false;
    }

    @Override
    public Boolean verifyAuthByQueryPolicy(List<AuthorityPolicy> policyList, String[] requiredActions, String resourceType, String tenantId) {
        List<AuthorityPolicy> tenantPolicyList = policyList.stream().filter(item -> tenantId.equals(item.getResourceId())).collect(Collectors.toList());
        Boolean tenantAuth = this.generalAuthLogic(tenantPolicyList, requiredActions, resourceType);
        if (tenantAuth.booleanValue()) {
            return true;
        }
        List<AuthorityPolicy> otherPolicyList = policyList.stream().filter(item -> !tenantId.equals(item.getResourceId())).collect(Collectors.toList());
        Boolean otherAuth = this.generalAuthLogic(otherPolicyList, requiredActions, resourceType);
        if (otherAuth.booleanValue()) {
            return true;
        }
        return false;
    }

    private Boolean generalAuthLogic(List<AuthorityPolicy> policyList, String[] requiredActions, String resourceType) {
        List denyPolicyList = policyList.stream().filter(item -> "deny".equals(item.getEffect())).collect(Collectors.toList());
        boolean presentDeny = denyPolicyList.stream().filter(item -> item.getAction().stream().anyMatch(action -> Arrays.stream(requiredActions).anyMatch(requiredAction -> (resourceType + requiredAction).equals(action)))).findAny().isPresent();
        if (presentDeny) {
            return false;
        }
        List allowPolicyList = policyList.stream().filter(item -> "allow".equals(item.getEffect())).collect(Collectors.toList());
        if (allowPolicyList.stream().filter(item -> item.getAction().stream().anyMatch(action -> action.endsWith(":*"))).findAny().isPresent()) {
            return true;
        }
        for (AuthorityPolicy authorityPolicy : allowPolicyList) {
            List action = authorityPolicy.getAction();
            for (String item2 : action) {
                if (!Arrays.stream(requiredActions).anyMatch(requiredAction -> (resourceType + requiredAction).equals(item2))) continue;
                return true;
            }
        }
        return false;
    }
}

