/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.auth.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.auth.annotation.DataAuth;
import com.digiwin.athena.auth.context.DataAuthContext;
import com.digiwin.athena.auth.domain.QueryAuthParam;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.auth.metadata.domain.ResourceCondition;
import com.digiwin.athena.auth.metadata.enums.AuthModeEnum;
import com.digiwin.athena.auth.service.AuthService;
import com.digiwin.athena.auth.service.DataCountService;
import com.digiwin.athena.auth.service.UserService;
import com.digiwin.athena.auth.util.AuthHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataAuthAspect {
    @Autowired(required=false)
    @Lazy
    private AuthService authService;
    @Autowired(required=false)
    @Lazy
    private DataCountService dataCountService;
    @Autowired
    @Lazy
    private UserService userService;
    @Autowired
    @Lazy
    private AuthHelper authHelper;
    @Value(value="${designer.auth.mode:FORBID}")
    private String authMode;
    @Value(value="${designer.auth.dbType:MONGO}")
    private String authDbType;
    @Value(value="${designer.domain:default}")
    private String designerDomain;

    @Pointcut(value="execution(* org.springframework.data.mongodb.core.MongoTemplate.find(..))")
    public void executeFind() {
    }

    @Before(value="@annotation(dataAuth)")
    public void dataAuthCheck(JoinPoint joinPoint, DataAuth dataAuth) {
        List policyList;
        if (AuthModeEnum.FORBID.name().equals(this.authMode)) {
            return;
        }
        if (!this.authDbType.equals("MONGO")) {
            throw new RuntimeException("\u4ec5\u652f\u6301MongoDB\u6570\u636e\u6e90\u4f7f\u7528\u6570\u636e\u6743\u9650!");
        }
        String resourceType = dataAuth.resourceType();
        String resourceId = dataAuth.resourceId();
        Object[] args = joinPoint.getArgs();
        resourceId = resourceId.startsWith("Json:") ? this.authHelper.getJSONValue(resourceId, args) : this.authHelper.getVarValue(args, resourceId);
        if (AuthModeEnum.LOCAL.name().equals(this.authMode)) {
            policyList = this.authService.queryDataAuthPolicy(this.userService.getCurrentUser(), resourceType, resourceId);
        } else {
            if (this.userService == null) {
                throw new RuntimeException("\u8bf7\u5b9e\u73b0com.digiwin.athena.auth.service.UserService\u63a5\u53e3");
            }
            QueryAuthParam queryAuthParam = new QueryAuthParam().setUserId(this.userService.getCurrentUser()).setResourceId(resourceId).setResourceType(resourceType);
            String response = ((HttpRequest)HttpUtil.createPost((String)(this.designerDomain + "/athena-designer/auth/queryDataAuthPolicy")).body(JSON.toJSONString((Object)queryAuthParam)).addHeaders(MapUtil.builder((Object)"digi-middleware-auth-user", (Object)this.userService.getToken()).build())).execute().body();
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)response, JSONObject.class);
            Integer code = jsonObject.getInteger("code");
            if (code == 0) {
                JSONArray data = jsonObject.getJSONArray("data");
                policyList = data.toJavaList(AuthorityPolicy.class);
            } else {
                throw new RuntimeException("\u67e5\u8be2\u6743\u9650\u5931\u8d25");
            }
        }
        if (CollUtil.isEmpty(policyList)) {
            DataAuthContext.setMongoCondition(MapUtil.builder((Object)resourceType, (Object)Criteria.where((String)"1").is((Object)"2")).build());
            return;
        }
        Criteria criteria = new Criteria();
        Boolean needCondition = true;
        ArrayList<Criteria> queryCondition = new ArrayList<Criteria>();
        for (AuthorityPolicy authorityPolicy : policyList) {
            List conditions = authorityPolicy.getConditions();
            if (CollUtil.isEmpty((Collection)conditions)) {
                needCondition = false;
                break;
            }
            for (ResourceCondition condition : conditions) {
                queryCondition.add(Criteria.where((String)condition.getField()).is((Object)condition.getValue()));
            }
        }
        if (!needCondition.booleanValue()) {
            criteria = null;
        } else {
            criteria.orOperator((Criteria[])ArrayUtil.toArray(queryCondition, Criteria.class));
        }
        DataAuthContext.setMongoCondition(MapUtil.builder((Object)resourceType, (Object)criteria).build());
        boolean throwException = dataAuth.throwException();
        if (throwException && needCondition.booleanValue()) {
            String pkValue = dataAuth.pkValue();
            Long count = this.dataCountService.count(resourceType, pkValue = this.authHelper.getJSONValue(pkValue, args), criteria);
            if (count <= 0L) {
                throw new RuntimeException("\u65e0\u6743\u8bbf\u95ee\u6539\u63a5\u53e3!");
            }
        }
    }

    @Around(value="executeFind()")
    public Object aroundExecuteFind(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        int length = args.length;
        if (length == 3) {
            String collection = String.valueOf(args[2]);
            Query query = (Query)args[0];
            Map<String, Criteria> mongoCondition = DataAuthContext.getMongoCondition();
            if (mongoCondition == null) {
                DataAuthContext.removeMongoCondition();
                return joinPoint.proceed();
            }
            Criteria criteria = mongoCondition.get(collection);
            if (criteria != null) {
                query.addCriteria((CriteriaDefinition)criteria);
            }
            args[0] = query;
            DataAuthContext.removeMongoCondition();
            return joinPoint.proceed(args);
        }
        DataAuthContext.removeMongoCondition();
        return joinPoint.proceed();
    }
}

