/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.auth.aspect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.auth.annotation.FuncAuth;
import com.digiwin.athena.auth.annotation.FuncAuth4Assign;
import com.digiwin.athena.auth.domain.QueryAuthParam;
import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.auth.metadata.enums.AuthModeEnum;
import com.digiwin.athena.auth.metadata.enums.PermissionPolicyEnum;
import com.digiwin.athena.auth.service.AuthApiService;
import com.digiwin.athena.auth.service.AuthService;
import com.digiwin.athena.auth.service.MongoDataService;
import com.digiwin.athena.auth.service.UserService;
import com.digiwin.athena.auth.util.AuthHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FuncAuth4AssignAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FuncAuth4AssignAspect.class);
    @Autowired(required=false)
    @Lazy
    private AuthService authService;
    @Autowired(required=false)
    @Lazy
    private MongoDataService mongoDataService;
    @Autowired
    @Lazy
    private UserService userService;
    @Autowired
    @Lazy
    private AuthHelper authHelper;
    @Value(value="${designer.auth.mode:FORBID}")
    private String authMode;
    @Value(value="${designer.domain:default}")
    private String designerDomain;
    @Autowired
    private AuthApiService authApiService;

    @Before(value="@annotation(funcAuth4Assign)")
    public void funcAuthCheck(JoinPoint joinPoint, FuncAuth4Assign funcAuth4Assign) {
        if (AuthModeEnum.FORBID.name().equals(this.authMode)) {
            return;
        }
        FuncAuth[] funcAuths = funcAuth4Assign.funcAuth();
        String operate = funcAuth4Assign.operate();
        HashMap<String, Boolean> authResult = new HashMap<String, Boolean>();
        for (FuncAuth funcAuth : funcAuths) {
            String resourceId = funcAuth.resourceId();
            String[] requiredActions = funcAuth.actions();
            Object[] args = joinPoint.getArgs();
            String resourceType = this.getResourceType(funcAuth, args);
            if (StrUtil.isNumeric((CharSequence)resourceId)) {
                resourceId = Arrays.stream(args).filter(item -> item != null).collect(Collectors.toList()).size() > Convert.toInt((Object)resourceId) ? String.valueOf(args[Convert.toInt((Object)resourceId)]) : null;
            } else if (resourceId.startsWith("Var:")) {
                resourceId = this.authHelper.getVarValue(args, resourceId);
            } else if (resourceId.startsWith("RelatePrimaryKey:")) {
                resourceId = this.getPkValue(args, resourceId, funcAuth.primaryKey());
            } else if (resourceId.startsWith("Json:")) {
                resourceId = this.authHelper.getJSONValue(resourceId, args);
            }
            List<AuthorityPolicy> policyList = new ArrayList<AuthorityPolicy>();
            if (AuthModeEnum.LOCAL.name().equals(this.authMode)) {
                QueryAuthParam queryAuthParam = new QueryAuthParam().setUserId(this.userService.getCurrentUser()).setResourceType(resourceType).setResourceId(resourceId);
                policyList = this.authService.queryFuncAuthPolicy(queryAuthParam);
            }
            String tenantId = this.userService.getTenantId();
            Boolean verified = this.authApiService.verifyAuthByQueryPolicy(policyList, requiredActions, resourceType, tenantId);
            authResult.put(funcAuth.resourceId(), verified);
        }
        boolean result = false;
        if ("and".equals(operate)) {
            Iterator iterator = authResult.values().iterator();
            while (iterator.hasNext()) {
                value = (Boolean)iterator.next();
                result = result && value;
            }
        } else {
            Iterator iterator = authResult.values().iterator();
            while (iterator.hasNext()) {
                value = (Boolean)iterator.next();
                result = result || value;
            }
        }
        if (!result) {
            throw new RuntimeException("\u65e0\u6743\u8bbf\u95ee\u8be5\u63a5\u53e3!");
        }
    }

    private String getEntityPkValue(String primaryKey, Object[] args) {
        String primaryKeyValue = primaryKey.startsWith("Var:") ? this.authHelper.getVarValue(args, primaryKey) : (primaryKey.startsWith("Json:") ? this.authHelper.getJSONValue(primaryKey, args) : String.valueOf(args[Convert.toInt((Object)primaryKey)]));
        return primaryKeyValue;
    }

    private String getResourceType(FuncAuth funcAuth, Object[] args) {
        String resourceType = funcAuth.resourceType();
        if (resourceType.startsWith("Var:")) {
            String var = resourceType.substring(resourceType.indexOf(":") + 1, resourceType.length());
            String[] split = var.split("#");
            String clazz = split[0];
            String field = split[1];
            for (Object arg : args) {
                if (!arg.getClass().getSimpleName().equals(clazz)) continue;
                Object fieldValue = ReflectUtil.getFieldValue((Object)arg, (String)field);
                resourceType = PermissionPolicyEnum.getResourceTypeByRole((String)String.valueOf(fieldValue));
                break;
            }
        } else if (StrUtil.isNumeric((CharSequence)resourceType)) {
            resourceType = String.valueOf(args[Convert.toInt((Object)resourceType)]);
        } else if (resourceType.startsWith("Json:")) {
            resourceType = this.authHelper.getJSONValue(resourceType, args);
            resourceType = PermissionPolicyEnum.getResourceTypeByRole((String)resourceType);
        }
        return resourceType;
    }

    private String getPkValue(Object[] args, String var, String primaryKey) {
        if (this.mongoDataService == null) {
            throw new RuntimeException("\u8bf7\u5b9e\u73b0com.digiwin.athena.auth.service.MongoDataService\u63a5\u53e3!");
        }
        String primaryKeyValue = this.getEntityPkValue(primaryKey, args);
        var = var.substring(var.indexOf(":") + 1, var.length());
        String[] split = var.split("\\|\\|");
        String result = null;
        for (String collectionInfo : split) {
            String[] arr = collectionInfo.split("#");
            String collection = arr[0];
            String primaryKeyField = arr[1];
            String applicationField = arr[2];
            JSONObject jsonObject = this.mongoDataService.queryOne(collection, primaryKeyField, primaryKeyValue);
            if (jsonObject == null) continue;
            result = jsonObject.getString(applicationField);
            break;
        }
        if (StrUtil.isBlank(result)) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u8be5\u5b9e\u4f53\u5bf9\u5e94\u7684\u5e94\u7528!");
        }
        return result;
    }
}

