package com.digiwin.athena.framework.apollo.config;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

public class DwApolloPostPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            // 先拿自定义的服务名, 未设置则默认值
            String appId = JaProperty.get("dw.apollo.appId");
            if (JaStringUtil.isSafeEmpty(appId)) {
                appId = JaEnvProperty.getApplicationName();
                if (JaStringUtil.isSafeEmpty(appId)) {
                    JaLog.warn("load apollo config error:appId is null");
                    return;
                }
            }
            System.setProperty("app.id", appId);
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("apollo.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
                String meta = JaProperty.get("apollo.meta");
                if (JaStringUtil.isSafeNotEmpty(meta)) {
                    System.setProperty("apollo.meta", meta);
                    System.setProperty("apollo.cluster", JaProperty.get("apollo.cluster", "2.2.12"));
                    System.setProperty("apollo.bootstrap.enabled", JaProperty.get("apollo.bootstrap.enabled", "true"));
                    System.setProperty("apollo.bootstrap.namespaces", JaProperty.get("apollo.bootstrap.namespaces", "application"));
                }

            }
        } catch (Throwable e) {
            JaLog.error("apollo config load error", e);
        }
    }
}
