/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.auth.filter;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.DwAthenaAuthProperties;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.filter.AuthCheck;
import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SecurityTokenCommonUtils;
import com.digiwin.athena.appcore.util.TokenCache;
import com.digiwin.athena.appcore.web.RequestMatcher;
import com.digiwin.athena.iam.sdk.manager.IamAuthManager;
import com.digiwin.athena.iam.sdk.manager.IamManager;
import com.digiwin.athena.iam.sdk.meta.dto.response.AuthoredUserDTO;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class UserTokenAuthenticationFilter
extends OncePerRequestFilter
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(UserTokenAuthenticationFilter.class);
    private List<RequestMatcher> requestMatchers;
    private DwAthenaAuthProperties dwAthenaAuthProperties;
    public static final String[] AUTH_WHITELIST = new String[]{"/", "/*.html", "/favicon.ico", "/**/*.html", "/**/*.css", "/**/*.js", "/webjars/**", "/swagger-resources/**", "/**/api-docs/**", "/**/env/**", "/error", "/druid/**", "/api/test", "/v2/api-docs", "/swagger-resources", "/swagger-resources/**", "/configuration/ui", "/configuration/security", "/swagger-ui.html", "/webjars/**", "/actuator/**", "/test/**", "/**/tool/**"};
    private static final String[] PREFIXES = new String[]{"NoSuch", "ParseError"};

    public UserTokenAuthenticationFilter(DwAthenaAuthProperties dwAthenaAuthProperties) {
        this.dwAthenaAuthProperties = dwAthenaAuthProperties;
    }

    private boolean inWriteList(HttpServletRequest request) {
        if (this.requestMatchers == null) {
            if (null != this.dwAthenaAuthProperties && null != this.dwAthenaAuthProperties.getWhiteList() && this.dwAthenaAuthProperties.getWhiteList().length != 0) {
                String[] newList = (String[])Stream.concat(Stream.of(this.dwAthenaAuthProperties.getWhiteList()), Stream.of(AUTH_WHITELIST)).toArray(String[]::new);
                this.requestMatchers = RequestMatcher.antMatchers(newList);
            } else {
                this.requestMatchers = RequestMatcher.antMatchers(AUTH_WHITELIST);
            }
        }
        for (RequestMatcher requestMatcher : this.requestMatchers) {
            boolean result = requestMatcher.matches(request);
            if (!result) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        AppAuthContextHolder.clearContext();
        if (request.getMethod().matches(HttpMethod.OPTIONS.name())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.setCustomRequestHeader(request);
        userToken = request.getHeader("digi-middleware-auth-user");
        if (StringUtils.isEmpty((Object)userToken)) {
            userToken = request.getHeader("token");
        }
        authentication = null;
        proxyAuthentication = null;
        securityToken = request.getHeader("security-token");
        if (!StringUtils.isEmpty((Object)securityToken) && null != (authentication = SecurityTokenCommonUtils.getAuthoredUserBySecurityToken(securityToken)) && StringUtils.isEmpty((Object)authentication.getToken())) {
            authentication.setToken(userToken);
        }
        if (authentication == null || JaStringUtil.isSafeEmpty((String)authentication.getVersion())) {
            securityToken = null;
            try {
                authentication = this.getUserInfo(userToken);
                this.verifyAndExchangeIamToken(authentication);
            }
            catch (BusinessException ex) {
                if (this.inWriteList(request) || !AuthCheck.isCheckAuth(request)) ** GOTO lbl25
                this.writeUnAuth(request, response, ex);
                return;
            }
        } else {
            this.verifyAndExchangeIamToken(authentication);
        }
lbl25:
        // 3 sources

        proxyToken = this.getRequestProxyToken(request);
        if (JaStringUtil.isNotEmpty((String)proxyToken)) {
            try {
                proxyAuthentication = this.getUserInfo(proxyToken);
                if (proxyAuthentication != null && JaStringUtil.isNotEmpty((String)authentication.getTenantId()) && JaStringUtil.isNotEmpty((String)proxyAuthentication.getTenantId())) {
                    if (authentication.getTenantId().equals(proxyAuthentication.getTenantId())) {
                        proxyAuthentication = null;
                        proxyToken = null;
                    } else {
                        request.setAttribute("digi-middleware-proxy-auth-user-data", (Object)proxyAuthentication);
                        AppAuthContextHolder.getContext().setProxyAuthoredUser(proxyAuthentication);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("\u4ee3\u7406token\u5931\u6548:" + proxyToken), (Throwable)e);
            }
        }
        if (authentication != null) {
            if (StringUtils.isEmpty((Object)securityToken)) {
                securityToken = proxyAuthentication != null ? SecurityTokenCommonUtils.generateSecurityToken("", proxyToken, proxyAuthentication, authentication) : SecurityTokenCommonUtils.generateSecurityToken("", userToken, authentication, null);
            }
            request.setAttribute("digi-middleware-auth-user-data", (Object)authentication);
            AppAuthContextHolder.getContext().setSecurityToken(securityToken);
            AppAuthContextHolder.getContext().setAuthoredUser(authentication);
            AppAuthContextHolder.getContext().setProxyToken(proxyToken);
        }
        if (StringUtils.hasText((String)(routerKey = request.getHeader("routerKey")))) {
            MDC.put((String)"routerKey", (String)routerKey);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        AppAuthContextHolder.clearContext();
    }

    private String getRequestProxyToken(HttpServletRequest request) {
        String proxyToken = request.getHeader("proxy_token");
        if (StringUtils.isEmpty((Object)proxyToken)) {
            proxyToken = request.getHeader("digi-proxy-token");
        }
        if (StringUtils.isEmpty((Object)proxyToken)) {
            proxyToken = request.getHeader("proxy-token");
        }
        return proxyToken;
    }

    private void writeUnAuth(HttpServletRequest request, HttpServletResponse response, BusinessException ex) throws IOException {
        if (JaStringUtil.isEmpty((String)ex.getBizErrorCode())) {
            throw ex;
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        BaseResultDTO<Object> result = this.getBaseResultG(request.getRequestURL().toString(), ex);
        response.getWriter().println(JaJson.toString(result));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private void setCustomRequestHeader(HttpServletRequest httpRequest) {
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>(16);
            Enumeration headerNames = httpRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = httpRequest.getHeader(key);
                headerMap.put(key, value);
            }
            AppAuthContextHolder.getContext().setRequestHeader(headerMap);
        }
        catch (Exception e) {
            this.logger.warn((Object)"\u8bf7\u6c42\u5934\u8d4b\u503c\u5931\u8d25");
        }
    }

    public AuthoredUser getUserInfo(String userToken) {
        AuthoredUserDTO userInfo = IamAuthManager.getUserInfo((String)userToken);
        AuthoredUser authoredUser = this.covert(userInfo);
        authoredUser.setToken(userToken);
        return authoredUser;
    }

    public void verifyAndExchangeIamToken(AuthoredUser authentication) {
        if (null != authentication.getTenantId() && !"integration".equals(authentication.getUserId())) {
            try {
                AuthoredUser authoredUser = TokenCache.getOrLoadAuthoredUser(authentication.getTenantId(), tenantId -> this.queryLoginInternal(authentication));
                AppAuthContextHolder.getContext().setIntegrationAuthoredUser(authoredUser);
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u7528\u6237\u96c6\u6210\u91d1\u94a5\u5931\u8d25");
                this.setIntegrationAuthoreUser(authentication);
            }
        } else {
            this.setIntegrationAuthoreUser(authentication);
        }
    }

    private AuthoredUser queryLoginInternal(AuthoredUser authentication) {
        AuthoredUser result = IamManager.queryApiVirtualToken((String)authentication.getTenantId());
        result.setUserName("\u96c6\u6210\u8d26\u53f7");
        result.setUserId("integration");
        result.setVersion(authentication.getVersion());
        return result;
    }

    private void setIntegrationAuthoreUser(AuthoredUser authentication) {
        AuthoredUser copy = new AuthoredUser();
        copy.setToken(authentication.getToken());
        copy.setSid(authentication.getSid());
        copy.setTenantSid(authentication.getTenantSid());
        copy.setTenantId(authentication.getTenantId());
        copy.setTenantName(authentication.getTenantName());
        copy.setIdentityType(authentication.getIdentityType());
        copy.setUserId(authentication.getUserId());
        copy.setUserName(authentication.getUserName());
        copy.setVersion(authentication.getVersion());
        AppAuthContextHolder.getContext().setIntegrationAuthoredUser(copy);
    }

    public AuthoredUser covert(AuthoredUserDTO authoredUserDTO) {
        if (authoredUserDTO == null) {
            return null;
        }
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setSid(authoredUserDTO.getSid());
        authoredUser.setUserId(authoredUserDTO.getUserId());
        authoredUser.setUserName(authoredUserDTO.getUserName());
        authoredUser.setToken(authoredUserDTO.getToken());
        authoredUser.setTenantSid(authoredUserDTO.getTenantSid());
        authoredUser.setTenantId(authoredUserDTO.getTenantId());
        authoredUser.setTenantName(authoredUserDTO.getTenantName());
        authoredUser.setIdentityType(authoredUserDTO.getIdentityType());
        authoredUser.setVersion(authoredUserDTO.getVersion());
        return authoredUser;
    }

    public BaseResultDTO<Object> getBaseResultG(String path, BusinessException businessException) {
        JaLog.error((String)"{} error : {}", (Object[])new Object[]{path, businessException});
        BaseResultDTO result = new BaseResultDTO();
        result.setBizErrorCode(businessException.getBizErrorCode());
        result.setBizErrorMsg(this.getBizErrorMsg(businessException));
        result.setStatus(Integer.valueOf(HttpStatus.UNAUTHORIZED.value()));
        result.setStatusDescription(HttpStatus.UNAUTHORIZED.getReasonPhrase());
        result.setPath(path);
        result.setErrorType(ErrorTypeEnum.BUSINESS.getValue());
        result.setErrorCode(String.valueOf(HttpStatus.UNAUTHORIZED.value()));
        result.setErrorMessage(this.getErrorMessage(businessException));
        result.setServerTime(Long.valueOf(System.currentTimeMillis()));
        return result;
    }

    private String getBizErrorMsg(BusinessException businessException) {
        if (StringUtils.isEmpty((Object)businessException.getBizErrorMsg())) {
            String codeMsg = JaI18nUtil.getMessage((String)businessException.getBizErrorCode(), (Object[])new Object[0]);
            if (Arrays.stream(PREFIXES).anyMatch(codeMsg::startsWith)) {
                codeMsg = this.genDefaultErrMsg();
            }
            return codeMsg;
        }
        return businessException.getBizErrorMsg();
    }

    private Object getErrorMessage(BusinessException businessException) {
        if (StringUtils.isEmpty((Object)businessException.getErrorMessage())) {
            String codeMsg = JaI18nUtil.getMessage((String)businessException.getErrorCode(), (Object[])new Object[0]);
            if (Arrays.stream(PREFIXES).anyMatch(codeMsg::startsWith)) {
                codeMsg = this.genDefaultErrMsg();
            }
            return codeMsg;
        }
        return businessException.getErrorMessage();
    }

    public String genDefaultErrMsg() {
        String local = LocaleContextHolder.getLocale().toString();
        String errorMessage = "\u9875\u9762\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\uff01";
        if (Objects.equals(local, "zh_TW") || Objects.equals(local, "zh-TW")) {
            errorMessage = "\u9801\u9762\u51fa\u73fe\u7570\u5e38\uff0c\u8acb\u806f\u7cfb\u5ba2\u670d\uff01";
        }
        if (Objects.equals(local, "en_US") || Objects.equals(local, "en-US")) {
            errorMessage = "The page is abnormal, please contact customer service!";
        }
        return errorMessage;
    }
}

