/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.util;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.TimeCache;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCache {
    private static final Logger log = LoggerFactory.getLogger(TokenCache.class);
    private static final TimeCache<String, AuthoredUser> TOKEN_CACHE = new TimeCache(86400000L);

    public static void cacheAuthoredUser(String key, AuthoredUser value) {
        if (null == value) {
            log.error("\u6570\u636e\u4e3a\u7a7a\uff1a{}", (Object)key);
            return;
        }
        TOKEN_CACHE.put(key, value);
    }

    public static AuthoredUser getCacheAuthoredUser(String key) {
        return TOKEN_CACHE.get(key);
    }

    public static TimeCache<String, AuthoredUser> getAll() {
        return TOKEN_CACHE;
    }

    public static AuthoredUser getOrLoadAuthoredUser(String key, Function<String, AuthoredUser> loader) {
        return TOKEN_CACHE.getOrLoad(key, loader);
    }
}

