/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.web;

import com.digiwin.athena.appcore.web.RequestMatcher;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;

public final class AntPathRequestMatcher
implements RequestMatcher {
    private static final Log logger = LogFactory.getLog(AntPathRequestMatcher.class);
    private static final String MATCH_ALL = "/**";
    private final Matcher matcher;
    private final String pattern;
    private final HttpMethod httpMethod;
    private final boolean caseSensitive;
    private final UrlPathHelper urlPathHelper;

    public AntPathRequestMatcher(String pattern) {
        this(pattern, null);
    }

    public AntPathRequestMatcher(String pattern, String httpMethod) {
        this(pattern, httpMethod, true);
    }

    public AntPathRequestMatcher(String pattern, String httpMethod, boolean caseSensitive) {
        this(pattern, httpMethod, caseSensitive, null);
    }

    public AntPathRequestMatcher(String pattern, String httpMethod, boolean caseSensitive, UrlPathHelper urlPathHelper) {
        Assert.hasText((String)pattern, (String)"Pattern cannot be null or empty");
        this.caseSensitive = caseSensitive;
        if (!pattern.equals(MATCH_ALL) && !pattern.equals("**")) {
            this.matcher = pattern.endsWith(MATCH_ALL) && pattern.indexOf(63) == -1 && pattern.indexOf(123) == -1 && pattern.indexOf(125) == -1 && pattern.indexOf("*") == pattern.length() - 2 ? new SubpathMatcher(pattern.substring(0, pattern.length() - 3), caseSensitive) : new SpringAntMatcher(pattern, caseSensitive);
        } else {
            pattern = MATCH_ALL;
            this.matcher = null;
        }
        this.pattern = pattern;
        this.httpMethod = StringUtils.hasText((String)httpMethod) ? HttpMethod.valueOf((String)httpMethod) : null;
        this.urlPathHelper = urlPathHelper;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        if (this.httpMethod != null && StringUtils.hasText((String)request.getMethod()) && this.httpMethod != AntPathRequestMatcher.valueOf(request.getMethod())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request '" + request.getMethod() + " " + this.getRequestPath(request) + "' doesn't match '" + this.httpMethod + " " + this.pattern + "'"));
            }
            return false;
        }
        if (this.pattern.equals(MATCH_ALL)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request '" + this.getRequestPath(request) + "' matched by universal pattern '/**'"));
            }
            return true;
        }
        String url = this.getRequestPath(request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking match of request : '" + url + "'; against '" + this.pattern + "'"));
        }
        return this.matcher.matches(url);
    }

    @Override
    @Deprecated
    public Map<String, String> extractUriTemplateVariables(HttpServletRequest request) {
        return this.matcher(request).getVariables();
    }

    @Override
    public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
        if (this.matcher != null && this.matches(request)) {
            String url = this.getRequestPath(request);
            return RequestMatcher.MatchResult.match(this.matcher.extractUriTemplateVariables(url));
        }
        return RequestMatcher.MatchResult.notMatch();
    }

    private String getRequestPath(HttpServletRequest request) {
        if (this.urlPathHelper != null) {
            return this.urlPathHelper.getPathWithinApplication(request);
        }
        String url = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            url = StringUtils.hasLength((String)url) ? url + pathInfo : pathInfo;
        }
        return url;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AntPathRequestMatcher)) {
            return false;
        }
        AntPathRequestMatcher other = (AntPathRequestMatcher)obj;
        return this.pattern.equals(other.pattern) && this.httpMethod == other.httpMethod && this.caseSensitive == other.caseSensitive;
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.hashCode() : 0;
        result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
        result = 31 * result + (this.caseSensitive ? 1231 : 1237);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ant [pattern='").append(this.pattern).append("'");
        if (this.httpMethod != null) {
            sb.append(", ").append(this.httpMethod);
        }
        sb.append("]");
        return sb.toString();
    }

    private static HttpMethod valueOf(String method) {
        try {
            return HttpMethod.valueOf((String)method);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);

        public Map<String, String> extractUriTemplateVariables(String var1);
    }

    private static class SpringAntMatcher
    implements Matcher {
        private final AntPathMatcher antMatcher;
        private final String pattern;

        private SpringAntMatcher(String pattern, boolean caseSensitive) {
            this.pattern = pattern;
            this.antMatcher = SpringAntMatcher.createMatcher(caseSensitive);
        }

        @Override
        public boolean matches(String path) {
            return this.antMatcher.match(this.pattern, path);
        }

        @Override
        public Map<String, String> extractUriTemplateVariables(String path) {
            return this.antMatcher.extractUriTemplateVariables(this.pattern, path);
        }

        private static AntPathMatcher createMatcher(boolean caseSensitive) {
            AntPathMatcher matcher = new AntPathMatcher();
            matcher.setTrimTokens(false);
            matcher.setCaseSensitive(caseSensitive);
            return matcher;
        }
    }

    private static class SubpathMatcher
    implements Matcher {
        private final String subpath;
        private final int length;
        private final boolean caseSensitive;

        private SubpathMatcher(String subpath, boolean caseSensitive) {
            assert (!subpath.contains("*"));
            this.subpath = caseSensitive ? subpath : subpath.toLowerCase();
            this.length = subpath.length();
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean matches(String path) {
            if (!this.caseSensitive) {
                path = path.toLowerCase();
            }
            return path.startsWith(this.subpath) && (path.length() == this.length || path.charAt(this.length) == '/');
        }

        @Override
        public Map<String, String> extractUriTemplateVariables(String path) {
            return Collections.emptyMap();
        }
    }
}

