/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.util;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTokenCommonUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityTokenCommonUtils.class);

    public static String generateSecurityToken(String appToken, String userToken, AuthoredUser authoredUser, AuthoredUser User) {
        HashMap<String, Object> profile = new HashMap<String, Object>();
        SecurityTokenCommonUtils.generateProfileMap(profile, authoredUser);
        if (null != User) {
            HashMap<String, Object> currentUser = new HashMap<String, Object>();
            SecurityTokenCommonUtils.generateProfileMap(currentUser, User);
            currentUser.put("userToken", User.getToken());
            profile.put("_currentUser", currentUser);
        }
        DWSecurityContext context = DWSecurityContext.getSecurityContext();
        context.setAppToken(appToken);
        context.setProfile(profile);
        context.setTokenVerified();
        try {
            return DWSecurityTokenUtil.generateSecurityToken((DWSecurityContext)context, (int)20);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void generateProfileMap(Map<String, Object> profile, AuthoredUser authoredUser) {
        profile.put("tenantId", authoredUser.getTenantId());
        profile.put("tenantName", authoredUser.getTenantName());
        profile.put("tenantSid", String.valueOf(authoredUser.getTenantSid()));
        profile.put("userId", authoredUser.getUserId());
        profile.put("userName", authoredUser.getUserName());
        profile.put("userSid", String.valueOf(authoredUser.getSid()));
        profile.put("version", authoredUser.getVersion());
    }

    public static AuthoredUser getAuthoredUserBySecurityToken(String securityToken) {
        try {
            DWSecurityToken dwSecurityToken = DWSecurityTokenUtil.parseSecurityToken((String)securityToken);
            if (dwSecurityToken != null && dwSecurityToken.getContext() != null && JaCollectionUtil.isNotEmpty((Map)dwSecurityToken.getContext().getProfile())) {
                AuthoredUser authentication = new AuthoredUser();
                Map profile = dwSecurityToken.getContext().getProfile();
                authentication.setTenantId(profile.get("tenantId").toString());
                authentication.setTenantName(profile.get("tenantName").toString());
                if (profile.containsKey("tenantSid")) {
                    authentication.setTenantSid(Long.parseLong(profile.get("tenantSid").toString()));
                }
                authentication.setUserId(profile.get("userId").toString());
                authentication.setUserName(profile.get("userName").toString());
                if (profile.containsKey("userSid")) {
                    authentication.setSid(Long.parseLong(profile.get("userSid").toString()));
                }
                if (Objects.nonNull(profile.get("version"))) {
                    authentication.setVersion(profile.get("version").toString());
                }
                return authentication;
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u4fe1\u4efb\u94fe\u5931\u8d25\uff0c\u4f7f\u7528\u6807\u51c6\u7684\u65b9\u5f0f\u9a8c\u8bc1", (Throwable)e);
            return null;
        }
    }
}

