package com.digiwin.athena.appcore.util;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.DWSecurityToken;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import com.digiwin.service.permission.consts.ConstDef;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Slf4j
public class SecurityTokenCommonUtils {

    /**
     * STEP1 這裡需要應用調用IAM的 API /api/iam/v2/identity/token/analyze 拿到下面的數據後生成security-token
     *
     * @param appToken  調用方的appToken
     * @param userToken 調用者的userToken
     * @return
     * @throws Exception
     */
    public static String generateSecurityToken(String appToken, String userToken, AuthoredUser authoredUser, AuthoredUser User) {
        // STEP2 需要應用從IAM接口返回成功的時候拿實際的返回值
        Map<String, Object> profile = new HashMap<>();
        generateProfileMap(profile, authoredUser);
        // 如果为代理token,则放入当前操作人token信息 13107
        if (null != User) {
            Map<String, Object> currentUser = new HashMap<>();
            generateProfileMap(currentUser, User);
            currentUser.put("userToken", User.getToken());
            profile.put("_currentUser", currentUser);
        }

        // STEP3 建置DWSecurityContext對象
        DWSecurityContext context = DWSecurityContext.getSecurityContext();
//        context.setUserToken(userToken);
        context.setAppToken(appToken);
        context.setProfile(profile);
        // userToken驗證成功
        context.setTokenVerified();
        // STEP4 生成security-token 有效時長20分鐘
        try {
            return DWSecurityTokenUtil.generateSecurityToken(context, 20);
        } catch (Exception e) {
            // 吃调异常，无法使用调用链的功能而已
            e.printStackTrace();
            return "";
        }
    }

    public static void generateProfileMap(Map<String, Object> profile, AuthoredUser authoredUser) {
        profile.put(ConstDef.ProfileKeyDef.TENANT_ID, authoredUser.getTenantId());
        profile.put(ConstDef.ProfileKeyDef.TENANT_NAME, authoredUser.getTenantName());
        profile.put(ConstDef.ProfileKeyDef.TENANT_SID, String.valueOf(authoredUser.getTenantSid()));
        profile.put(ConstDef.ProfileKeyDef.USER_ID, authoredUser.getUserId());
        profile.put(ConstDef.ProfileKeyDef.USER_NAME, authoredUser.getUserName());
        profile.put(ConstDef.ProfileKeyDef.USER_SID, String.valueOf(authoredUser.getSid()));
        profile.put("version", authoredUser.getVersion());
    }

    public static AuthoredUser getAuthoredUserBySecurityToken(String securityToken) {
        try {
            DWSecurityToken dwSecurityToken = DWSecurityTokenUtil.parseSecurityToken(securityToken);
            if (dwSecurityToken != null && dwSecurityToken.getContext() != null
                    && JaCollectionUtil.isNotEmpty(dwSecurityToken.getContext().getProfile())) {
                AuthoredUser authentication = new AuthoredUser();
                Map<String, Object> profile = dwSecurityToken.getContext().getProfile();
                authentication.setTenantId(profile.get(ConstDef.ProfileKeyDef.TENANT_ID).toString());
                authentication.setTenantName(profile.get(ConstDef.ProfileKeyDef.TENANT_NAME).toString());
                if (profile.containsKey(ConstDef.ProfileKeyDef.TENANT_SID)) {
                    authentication.setTenantSid(Long.parseLong(profile.get(ConstDef.ProfileKeyDef.TENANT_SID).toString()));
                }
                authentication.setUserId(profile.get(ConstDef.ProfileKeyDef.USER_ID).toString());
                authentication.setUserName(profile.get(ConstDef.ProfileKeyDef.USER_NAME).toString());
                if (profile.containsKey(ConstDef.ProfileKeyDef.USER_SID)) {
                    authentication.setSid(Long.parseLong(profile.get(ConstDef.ProfileKeyDef.USER_SID).toString()));
                }
//                authentication.setToken(dwSecurityToken.getContext().getUserToken());
                if (Objects.nonNull(profile.get("version"))) {
                    authentication.setVersion(profile.get("version").toString());
                }
                return authentication;
            }
            return null;
        } catch (Exception e) {
            log.error("信任链失败，使用标准的方式验证", e);
            // 信任链失败，使用标准的方式验证
            return null;
        }
    }
}
