package com.digiwin.athena.appcore.auth;

import com.digiwin.athena.appcore.web.AntPathRequestMatcher;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

@Slf4j
public class DwAthenaAuthConfigUpdater implements InitializingBean {
    private final DwAthenaAuthProperties configurer;

    public DwAthenaAuthConfigUpdater(DwAthenaAuthProperties configurer) {
        this.configurer = configurer;
    }

    public void nacosUpdate() {
        JaPropertyListener.addCommonListener(() -> {
            JaSpringPropertyProcessor.refresh(DwAthenaAuthProperties.class);
            AntPathRequestMatcher.initRequestMatchers(configurer);
        });
    }

    @Override
    public void afterPropertiesSet() {
        nacosUpdate();
    }
}
