package com.digiwin.athena.appcore.auth;

import com.alibaba.nacos.common.http.HttpClientConfig;
import com.digiwin.athena.appcore.auth.filter.UserTokenAuthenticationFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@ConditionalOnWebApplication
@ConditionalOnProperty(name = {"athena.auth.enable"}, havingValue = "true")
@AutoConfigureAfter(HttpClientConfig.class)
@Configuration
@EnableConfigurationProperties(DwAthenaAuthProperties.class)
public class DwAthenaAuthConfiguration {

    @Bean("UserTokenAuthenticationFilter")
    public FilterRegistrationBean traceFilterRegistration(DwAthenaAuthProperties dwAthenaAuthProperties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(new UserTokenAuthenticationFilter(dwAthenaAuthProperties));
        registration.addUrlPatterns("/*");
        registration.setName("UserTokenAuthenticationFilter");
        registration.setOrder(Ordered.HIGHEST_PRECEDENCE + 10);
        return registration;
    }

    @Bean
    public DwAthenaAuthConfigUpdater localDispatcherConfigUpdater(DwAthenaAuthProperties configurer) {
        return new DwAthenaAuthConfigUpdater(configurer);
    }
}
