package com.digiwin.athena.appcore.util;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Function;

/**
 * 目前集成token的规则：租户+应用维度，有效期30天，
 * 每天使用会自动重置有效期，如果没有任何用户的请求，就30天到期。
 * @author wzq
 */
@Slf4j
public class TokenCache {
    /**
     * 缓存时间24小时
     */
    private static final TimeCache<String, AuthoredUser> TOKEN_CACHE = new TimeCache<>(24 * 60 * 60 * 1000);

    public static void cacheAuthoredUser(String key, AuthoredUser value) {
        if (null == value) {
            log.error("数据为空：{}", key);
            return;
        }
        TOKEN_CACHE.put(key, value);
    }

    public static AuthoredUser getCacheAuthoredUser(String key) {
        return TOKEN_CACHE.get(key);
    }

    public static TimeCache<String, AuthoredUser> getAll() {
        return TOKEN_CACHE;
    }

    /**
     * 获取或加载用户凭证（原子操作）
     */
    public static AuthoredUser getOrLoadAuthoredUser(String key, Function<String, AuthoredUser> loader) {
        return TOKEN_CACHE.getOrLoad(key, loader);
    }
}


