package com.digiwin.athena.appcore.web;

import org.springframework.http.HttpMethod;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface RequestMatcher {
    boolean matches(HttpServletRequest var1);

    Map<String, String> extractUriTemplateVariables(HttpServletRequest var1);


    default MatchResult matcher(HttpServletRequest request) {
        boolean match = this.matches(request);
        return new MatchResult(match, Collections.emptyMap());
    }

    public static List<RequestMatcher> antMatchers(HttpMethod httpMethod, String... antPatterns) {
        String method = httpMethod == null ? null : httpMethod.toString();
        List<RequestMatcher> matchers = new ArrayList();
        String[] var4 = antPatterns;
        int var5 = antPatterns.length;

        for(int var6 = 0; var6 < var5; ++var6) {
            String pattern = var4[var6];
            matchers.add(new AntPathRequestMatcher(pattern, method));
        }

        return matchers;
    }

    public static List<RequestMatcher> antMatchers(String... antPatterns) {
        return antMatchers((HttpMethod)null, antPatterns);
    }

    public static class MatchResult {
        private final boolean match;
        private final Map<String, String> variables;

        MatchResult(boolean match, Map<String, String> variables) {
            this.match = match;
            this.variables = variables;
        }

        public boolean isMatch() {
            return this.match;
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        public static MatchResult match() {
            return new MatchResult(true, Collections.emptyMap());
        }

        public static MatchResult match(Map<String, String> variables) {
            return new MatchResult(true, variables);
        }

        public static MatchResult notMatch() {
            return new MatchResult(false, Collections.emptyMap());
        }
    }
}
