/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(TimeCache.class);
    private Map<K, ValueWrapper<V>> map = new ConcurrentHashMap<K, ValueWrapper<V>>();
    private long timeout;
    private final ScheduledExecutorService schedule;

    public TimeCache(long timeout) {
        this.timeout = timeout;
        this.schedule = Executors.newSingleThreadScheduledExecutor();
        this.schedule.scheduleAtFixedRate(this::cleanup, 0L, 12L, TimeUnit.HOURS);
    }

    public void put(K key, V value, long ttlMillis) {
        long expireTime = System.currentTimeMillis() + ttlMillis;
        this.map.put(key, new ValueWrapper<V>(value, expireTime));
    }

    public void put(K key, V value) {
        this.put(key, value, this.timeout);
    }

    public V get(K key) {
        ValueWrapper<V> wrapper = this.map.get(key);
        if (wrapper == null) {
            return null;
        }
        if (System.currentTimeMillis() > wrapper.expireTime) {
            this.map.remove(key);
            return null;
        }
        return wrapper.value;
    }

    public V getOrLoad(K key, Function<K, V> loader) {
        return this.getOrLoad(key, loader, this.timeout);
    }

    public V getOrLoad(K key, Function<K, V> loader, long ttlMillis) {
        return this.map.compute(key, (BiFunction<Object, ValueWrapper, ValueWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getOrLoad$0(java.util.function.Function long java.lang.Object com.digiwin.athena.appcore.util.TimeCache$ValueWrapper ), (Ljava/lang/Object;Lcom/digiwin/athena/appcore/util/TimeCache$ValueWrapper;)Lcom/digiwin/athena/appcore/util/TimeCache$ValueWrapper;)((TimeCache)this, loader, (long)ttlMillis)).value;
    }

    public V remove(K key) {
        ValueWrapper<V> wrapper = this.map.remove(key);
        return wrapper != null && !this.isExpired(wrapper) ? (V)wrapper.value : null;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public void cleanup() {
        log.info("\u6267\u884c\u6e05\u7406");
        this.map.entrySet().removeIf(entry -> entry.getValue() == null || this.isExpired((ValueWrapper)entry.getValue()));
    }

    private boolean isExpired(ValueWrapper<V> wrapper) {
        return System.currentTimeMillis() > wrapper.expireTime;
    }

    private /* synthetic */ ValueWrapper lambda$getOrLoad$0(Function loader, long ttlMillis, Object k, ValueWrapper existingWrapper) {
        if (existingWrapper != null && !this.isExpired(existingWrapper)) {
            return existingWrapper;
        }
        Object newValue = loader.apply(k);
        if (newValue == null) {
            return null;
        }
        return new ValueWrapper(newValue, System.currentTimeMillis() + ttlMillis);
    }

    private static class ValueWrapper<V> {
        final V value;
        final long expireTime;

        ValueWrapper(V value, long expireTime) {
            this.value = value;
            this.expireTime = expireTime;
        }
    }
}

