package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

/**
 * 公共配置项
 * 各个服务的url等
 *
 * @author gengwei
 * @since 2024/10/28 10:09
 */
public class DwBizCommonPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("biz-common.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
        } catch (Throwable e) {
            JaLog.error("biz-common nacos read error", e);
        }

    }

    @Override
    public int order() {
        return -10;
    }
}
