package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

import java.util.Map;

/**
 * 抽取redis的公共配置，host，port 等
 *
 * @author gengwei
 * @since 2024/12/10 10:09
 */
public class DwRedisPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("redis.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
            String host = JaProperty.get("dw.redis.host");
            Integer port = JaProperty.getInteger("dw.redis.port");
            String password = JaProperty.get("dw.redis.password");

            Map<String, Object> propertyMap = JaProperty.getPropertyMap();

            // dw.redis.host 赋值给 spring.redis.host
            if (JaStringUtil.isSafeNotEmpty(host)) {
                JaLog.info("wrapRedis host: {}={}", "spring.redis.host", host);
                propertyMap.putIfAbsent("spring.redis.host", host);
            }
            // dw.redis.port 赋值给 spring.redis.port
            if (port != null) {
                JaLog.info("wrapRedis port: {}={}", "spring.redis.port", port);
                propertyMap.putIfAbsent("spring.redis.port", port);

            }
            // dw.redis.password 赋值给 spring.redis.password
            if (JaStringUtil.isSafeNotEmpty(password)) {
                JaLog.info("wrapRedis password: {}={}", "spring.redis.password", password);
                propertyMap.putIfAbsent("spring.redis.password", password);
            }
        } catch (Throwable e) {
            JaLog.error("redis nacos read error", e);
        }

    }

    @Override
    public int order() {
        return 10;
    }
}
