//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.ArrayUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.jugg.agile.biz.digiwin.esp.EspSdkHook;
import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.meta.JaReturn2;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.adapter.gson.JaGsonAdapter;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractInvoker {
    AbstractInvoker() {
    }

    protected abstract String getTargetUrl(MessageModel var1);

    protected abstract Map<String, Object> getRequestHeaders(RequestModel var1) throws Exception;

    protected abstract Map<String, Object> getResponseHeaders(HttpResponse var1, RequestModel var2);

    protected abstract void saveRequestLog(String var1, Map<String, Object> var2, Map<String, Object> var3, String var4) throws ClientProtocolException, IOException;

    protected abstract void saveResponseLog(String var1, Map<String, Object> var2, Integer var3, Map<String, Object> var4, String var5) throws ClientProtocolException, IOException;

    protected abstract void saveResponseErrorLog(String var1, Map<String, Object> var2, Exception var3) throws ClientProtocolException, IOException;

    private static final NodeKind Esp = new NodeKind("esp");

    protected void execute(MessageModel messageModel) throws Throwable {
        String tTargetUrl = this.getTargetUrl(messageModel);
        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);

        String id = tTargetUrl;
        RequestModel requestModel = messageModel.getRequestModel();
        if (null != requestModel) {
            String serviceName = requestModel.getServiceName();
            if (JaStringUtil.isNotEmpty(serviceName)) {
                id += "/" + serviceName;
            }
        }
        NodeSpan nodeSpan = NodeSpan.builder()
                .id(id)
                .nodeKind(Esp)
                .build();
        JaDapper.dapper(nodeSpan
                , new Object[]{messageModel.getRequestModel().getBodyJsonString()}
                , () -> executeOld(messageModel, tTargetUrl, tStringEntity)
        );
    }

    protected String executeOld(MessageModel messageModel, String tTargetUrl, StringEntity tStringEntity) throws Exception {
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        EspSdkHook.RequestHook.apply(tHttpPost);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        Iterator var6 = tKeySet.iterator();

        while (var6.hasNext()) {
            String tKey = (String) var6.next();
            if (reqHeaders.get(tKey) != null) {
                tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
            }
        }

        if ("standard".equals(messageModel.getInvokeProductType())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        } else if (ArrayUtil.containsIngoreCase(AppConstant.APP_AUTH_EXCLUDE, messageModel.getRequestModel().getServiceProd().trim())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        }

        tHttpPost.setEntity(tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());

        try {
            JaLog.info("esp header:{}", JaGsonAdapter.Instance.toString(reqHeaders));

            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp(tHttpPost, messageModel.getRequestModel().isIdempotency());

            Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
            Map<String, Object> resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
            String resp = EntityUtils.toString(tHttpResponse.getEntity());
            ResponseModel tResponseModel = new ResponseModel(resHeaders, resp);
//            this.saveResponseLog(messageModel.getRequestModel().getTenantId(), reqHeaders, tHttpStatus, resHeaders, tResponseModel.getBodyJsonString());
            messageModel.setResponseModel(tResponseModel);
            //删除无用代码
//            EspBody espBody = JSON.parseObject(resp, EspBody.class);
//            espBody.setTenantId(messageModel.getRequestModel().getTenantId());
            EspSdkHook.ResponseHook.apply(new JaReturn2<>(messageModel, resp));
            return resp;
        } catch (Throwable var11) {
            EspSdkHook.ThrowableHook.apply(new JaReturn2<>(var11, messageModel));
            throw var11;
        }
    }

    public static void main(String[] args) {


    }
}
