package com.jugg.agile.biz.digiwin.esp;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.io.file.JaFileReadUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.loader.JaAppClassLoader;

import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.Collections;

public class EspSdkJavaCompiler {
    public static void test() {
        try {
            String sourceCode = JaFileReadUtil.readAsString("sourceCode/AbstractInvoker.txt");

            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);

            // Create output directory
            File outDir = new File("out");
            outDir.mkdir();
            Iterable<File> files = Collections.singletonList(outDir);
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, files);


            String className = "com.digiwin.athena.esp.sdk.AbstractInvoker";
            JavaFileObject javaFileObject = new InMemoryJavaFileObject(className, sourceCode);
            Iterable<? extends JavaFileObject> compilationUnits = Collections.singletonList(javaFileObject);

            JavaCompiler.CompilationTask task = compiler.getTask(null
                    , fileManager, null, null, null, compilationUnits);
            if (Boolean.TRUE.equals(task.call())) {


                // Compilation was successful
                // You can now load the class, or store the bytes, etc.
                // For this example, we're just printing out a success message
                System.out.println("Compilation successful.");
//            URI classFileUri = URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension);
//            byte[] classBytes = Files.readAllBytes(Paths.get(classFileUri));
//            System.out.println(classBytes);
                // Get class bytes from disk

                // 读取.class文件为byte[]
                byte[] classBytes = Files.readAllBytes(outDir.toPath().resolve("com.digiwin.athena.esp.sdk".replace(".", "/") + "/AbstractInvoker.class"));
                // 通过字节码byte[] 加载class
                Class<?> aClass = JaAppClassLoader.defineClass(className, classBytes);
            } else {
                // Compilation failed
                System.out.println("Compilation failed.");
            }
        } catch (Throwable e) {
            JaLog.error("compiler error", e);
        }
    }


    static class InMemoryJavaFileObject extends SimpleJavaFileObject {
        final String code;

        InMemoryJavaFileObject(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + Kind.SOURCE.extension), Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return code;
        }
    }

    public static void main(String[] args) {
        System.out.println(JaFileReadUtil.readAsString("sourceCode/AbstractInvoker.txt"));
        test();
    }
}
