package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 抽取mongo的公共配置，uri: mongodb://ThemeMap:ThemeMap!QAZ2wsx@47.102.215.110:22696 等
 *
 * @author gengwei
 * @since 2024/12/10 10:09
 */
public class DwMongoPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("mongodb.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
            String uri = JaProperty.get("dw.mongodb.uri");

            Set<String> keys = JaProperty.getPropertyMap().keySet();
            // spring.data.mongodb-xxx
            Set<String> mongoNameKey = keys.stream()
                    .filter(key -> key.startsWith("spring.data.mongodb"))
                    .map(key -> key.substring(0, key.lastIndexOf(".")))
                    .collect(Collectors.toSet());
            Map<String, Object> propertyMap = JaProperty.getPropertyMap();
            mongoNameKey.forEach(key -> {
                // dw.mongodb.uri 赋值给 spring.data.mongodb-xxx.uri
                if (JaStringUtil.isSafeNotEmpty(uri)) {
                    JaLog.info("wrapMongo uri: {}={}", key + ".uri", uri);
                    propertyMap.putIfAbsent(key + ".uri", uri);
                }
            });
        } catch (Throwable e) {
            JaLog.error("mongo nacos read error", e);
        }

    }

    @Override
    public int order() {
        return 10;
    }
}
