/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.ArrayUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.jugg.agile.biz.digiwin.esp.EspCacheProcessor;
import com.jugg.agile.biz.digiwin.esp.EspSdkHook;
import com.jugg.agile.framework.core.dapper.JaDapper;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.meta.JaReturn2;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.adapter.gson.JaGsonAdapter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

abstract class AbstractInvoker {
    private static final NodeKind Esp = new NodeKind("esp");

    AbstractInvoker() {
    }

    protected abstract String getTargetUrl(MessageModel var1);

    protected abstract Map<String, Object> getRequestHeaders(RequestModel var1) throws Exception;

    protected abstract Map<String, Object> getResponseHeaders(HttpResponse var1, RequestModel var2);

    protected abstract void saveRequestLog(String var1, Map<String, Object> var2, Map<String, Object> var3, String var4) throws ClientProtocolException, IOException;

    protected abstract void saveResponseLog(String var1, Map<String, Object> var2, Integer var3, Map<String, Object> var4, String var5) throws ClientProtocolException, IOException;

    protected abstract void saveResponseErrorLog(String var1, Map<String, Object> var2, Exception var3) throws ClientProtocolException, IOException;

    protected void execute(MessageModel messageModel) throws Throwable {
        String serviceName;
        String tTargetUrl = this.getTargetUrl(messageModel);
        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        String id = tTargetUrl;
        RequestModel requestModel = messageModel.getRequestModel();
        if (null != requestModel && JaStringUtil.isNotEmpty((String)(serviceName = requestModel.getServiceName()))) {
            id = id + "/" + serviceName;
        }
        NodeSpan nodeSpan = NodeSpan.builder().id(id).nodeKind(Esp).build();
        String finalId = id;
        JaDapper.dapper((NodeSpan)nodeSpan, (Object[])new Object[]{messageModel.getRequestModel().getBodyJsonString()}, () -> this.executeOld(messageModel, tTargetUrl, tStringEntity, finalId));
    }

    protected String executeOld(MessageModel messageModel, String tTargetUrl, StringEntity tStringEntity, String id) throws Exception {
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        EspSdkHook.RequestHook.apply((Object)tHttpPost);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        for (String tKey : tKeySet) {
            if (reqHeaders.get(tKey) == null) continue;
            tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
        }
        if ("standard".equals(messageModel.getInvokeProductType())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        } else if (ArrayUtil.containsIngoreCase((String[])AppConstant.APP_AUTH_EXCLUDE, (String)messageModel.getRequestModel().getServiceProd().trim())) {
            tHttpPost.removeHeaders("digi-middleware-auth-app");
            tHttpPost.removeHeaders("digi-middleware-auth-app-secret");
        }
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());
        try {
            String resp = null;
            Map<String, Object> resHeaders = null;
            JaLog.info((String)"esp header:{}", (Object[])new Object[]{JaGsonAdapter.Instance.toString(reqHeaders)});
            JaReturn2<String, Map<String, Object>> tempCache = EspCacheProcessor.getTempCache(id);
            if (tempCache == null) {
                HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost, (boolean)messageModel.getRequestModel().isIdempotency());
                Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
                resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
                resp = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
            } else {
                EspCacheProcessor.setTempCache(id, resp, resHeaders);
            }
            ResponseModel tResponseModel = new ResponseModel(resHeaders, resp);
            messageModel.setResponseModel(tResponseModel);
            EspSdkHook.ResponseHook.apply((Object)new JaReturn2((Object)messageModel, resp));
            return resp;
        }
        catch (Throwable var11) {
            EspSdkHook.ThrowableHook.apply((Object)new JaReturn2((Object)var11, (Object)messageModel));
            throw var11;
        }
    }

    public static void main(String[] args) {
    }
}

