package com.jugg.agile.biz.digiwin.config.common.post;

import com.digiwin.athena.framework.core.config.env.DwOPSEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

/**
 * 私有化部署适配
 * TODO 待定, 是否适配整个智驱, 原因 : 多rds, 多mongo是否配置统一???
 * https://docs.qq.com/sheet/DSk1ZTnBFWUNhRGJD?tab=BB08J2
 * <p>
 * 1.地端中间件部署 所有中间件用一套配置
 * 2.所有配置都会追加到环境变量里面
 *
 * @author chenjian
 * @since 2024年09月02日 09:58:31
 */
public class DwPrivateDeploymentPostPropertyHandler implements JaPostPropertyHandler {
    private Set<String> atmcMongoKey = new HashSet<>();
    private Set<String> atmcRedisKey = new HashSet<>();

    public DwPrivateDeploymentPostPropertyHandler() {
        atmcMongoKey.add("spring.data.ptmprimary.uri");
        atmcMongoKey.add("spring.data.ptmlog.uri");
        atmcMongoKey.add("spring.data.ptmslave.uri");
        atmcMongoKey.add("spring.data.ptmddsm.uri");
        atmcMongoKey.add("dataComparison.mongo.uri");
        atmcMongoKey.add("datafootprint.mongo.uri");

        atmcRedisKey.add("athena.redis.ptm.password");
        atmcRedisKey.add("athena.redis.ptm.host");
        atmcRedisKey.add("athena.redis.ptm.port");
    }

    @Override
    public void addAndCover() {
        if (DwOPSEnvPropertyHandler.getIsLocal()) {
            if (appNoNeedCoverConfig()) {
                return;
            }

            wrapNacosDiscovery();
            wrapMysql();
            wrapDomain();
            wrapMongodb();
            wrapRedis();
            wrapRedisson();
            wrapMq();
        }
    }

    private static boolean appNoNeedCoverConfig() {
        String appName = Optional.ofNullable(JaEnvProperty.getEntity()).map(JaEnvProperty.Entity::getApplicationName).orElse("");
        return "aim".equals(appName);
    }

    private void wrapMq() {
        JaProperty.getPropertyMap().put("spring.rabbitmq.outhost", "");

        // 根据"spring.rabbitmq.addresses" 来构建 rabbit.mquri
        Object rabbitUri = JaProperty.getPropertyMap().get("spring.rabbitmq.addresses");
        JaLog.info("rabbitUri={}", rabbitUri);
        JaProperty.getPropertyMap().put("rabbit.mquri", rabbitUri);

        // 禁用mq监控
        JaProperty.getPropertyMap().put("athena.mq.monitor.enable", false);
    }

    private void wrapRedis() {

        String host = System.getenv().get("spring.redis.host");
        String password = System.getenv().get("spring.redis.password");
        String port = System.getenv().get("spring.redis.port");
        if (JaStringUtil.isSafeEmpty(host)) {
            return;
        }

        JaEnvProperty.Entity entity = JaEnvProperty.getEntity();
        // TODO 后续针对单个服务有特殊key时，单独写一个module
        String applicationName = entity.getApplicationName();
        if ("atmc".equals(applicationName) || "datacomparison".equals(applicationName) || "datafootprint".equals(applicationName) || "ptm".equals(applicationName)) {
            Set<String> keys = JaProperty.getPropertyMap().keySet();
            keys.forEach(key -> {
                if ("athena.redis.ptm.password".equals(key)) {
                    JaLog.info("wrapRedis : {}={}", key, password);
                    JaProperty.getPropertyMap().put(key, password);
                }
                if ("athena.redis.ptm.host".equals(key)) {
                    JaLog.info("wrapRedis : {}={}", key, host);
                    JaProperty.getPropertyMap().put(key, host);
                }
                if ("athena.redis.ptm.port".equals(key)) {
                    JaLog.info("wrapRedis : {}={}", key, port);
                    JaProperty.getPropertyMap().put(key, port);
                }

            });

        }


    }


    @Override
    public int order() {
        return 10;
    }

    private void wrapNacosDiscovery() {
        JaProperty.getPropertyMap().put("dwdiscoveryServer", System.getenv().get("spring.cloud.nacos.discovery.server-addr"));
    }

    private void wrapMysql() {
        String host = System.getenv().get("custom.datasource.host");
        if (JaStringUtil.isSafeEmpty(host)) {
            return;
        }
        String port = System.getenv().get("custom.datasource.port");

        Set<String> keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            boolean isDatasourceKey = key.startsWith("spring.datasource.");
            if (isDatasourceKey) {

                if (key.endsWith(".url")) {
                    String oldJdbcUrl = JaProperty.get(key);
                    int i = oldJdbcUrl.indexOf("//") + 2;
                    int i1 = oldJdbcUrl.indexOf("?");
                    // 47.102.215.110:22698/athena_im
                    String substring = oldJdbcUrl.substring(i, i1);
                    String database = substring.split("/")[1];
                    // jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
                    String jdbcUrl = String.format("jdbc:mysql://%s:%s/%s?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true", host, port, database);
                    JaProperty.getPropertyMap().put("spring.datasource.driver-class-name", "com.mysql.cj.jdbc.Driver");
                    JaLog.info("wrapMysql : {}={}", key, jdbcUrl);
                    JaProperty.getPropertyMap().put(key, jdbcUrl);
                }
                // spring.datasource.username 赋值给 spring.datasource.druid.xxxx.username
                if (key.endsWith(".username")) {
                    String datasourceUsername = JaProperty.get("spring.datasource.username");
                    if (JaStringUtil.isSafeNotEmpty(datasourceUsername)) {
                        JaLog.info("wrapMysql username: {}={}", key, datasourceUsername);
                        JaProperty.getPropertyMap().put(key, datasourceUsername);
                    }

                }
                // spring.datasource.password 赋值给 spring.datasource.druid.xxxx.password
                if (key.endsWith(".password")) {
                    String datasourcePassword = JaProperty.get("spring.datasource.password");
                    if (JaStringUtil.isSafeNotEmpty(datasourcePassword)) {
                        JaLog.info("wrapMysql password: {}={}", key, datasourcePassword);
                        JaProperty.getPropertyMap().put(key, datasourcePassword);
                    }
                }
            }

        });
    }

    public static void main(String[] args) {
        System.out.println("digiwincloudlocal.com.cn/".replace("digiwincloudlocal.com.cn", "xxxxx"));

        String oldJdbcUrl = "jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true";
        int i = oldJdbcUrl.indexOf("//") + 2;
        int i1 = oldJdbcUrl.indexOf("?");
        // 47.102.215.110:22698/athena_im
        String substring = oldJdbcUrl.substring(i, i1);
        String database = substring.split("/")[1];
        // jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
        String jdbcUrl = String.format("jdbc:mariadb://%s:%s/%s?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true", "host", "port", database);

        System.out.println(jdbcUrl);

        // jdbc:mariadb://host:port/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
        // jdbc:mysql://47.102.215.110:22698/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true

        // ?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true
        // ?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true

    }

    private void wrapMongodb() {
        String cluster = System.getenv().get("custom.data.mongodb.cluster");
        if (JaStringUtil.isSafeEmpty(cluster)) {
            return;
        }

        String username = System.getenv().get("spring.data.mongodb.username");
        String password = System.getenv().get("spring.data.mongodb.password");

        // mongodb+srv://<db_username>:<db_password>@<clusterName>.mongodb.net/?retryWrites=true&w=majority
        String mongoUri = String.format("mongodb://%s:%s@%s", username, password, cluster);
        JaEnvProperty.Entity entity = JaEnvProperty.getEntity();
        Set<String> keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            if (key.startsWith("spring.data.") && key.contains("mongodb")) {
                if (key.endsWith(".uri")) {
                    JaLog.info("wrapMongodb : {}={}", key, mongoUri);
                    JaProperty.getPropertyMap().put(key, mongoUri);
                }
            }
            // TODO 后续针对单个服务有特殊key时，单独写一个module
            String applicationName = entity.getApplicationName();
            if ("atmc".equals(applicationName) || "datacomparison".equals(applicationName) || "datafootprint".equals(applicationName) || "ptm".equals(applicationName)) {
                if (atmcMongoKey.contains(key)) {
                    JaLog.info("wrapMongodb : {}={}", key, mongoUri);
                    JaProperty.getPropertyMap().put(key, mongoUri);
                }
            }
        });
    }


    private void wrapDomain() {
        String domainLocal = System.getenv().get("custom.domain");
        if (JaStringUtil.isSafeEmpty(domainLocal)) {
            return;
        }

        // https://iam.digiwincloud.com.cn          >       http://iam.project.com
        // https://iam.apps.digiwincloud.com.cn     >       http://iam.project.com
        // https://iam.digiwincloud.com.cn          >       http://iam.athena.127.0.0.1.nip.io


        String domainCNA = "apps.digiwincloud.com.cn";
        String domainCNB = "digiwincloud.com.cn";


        String domainTWA = "apps.digiwincloud.com";
        String domainTWB = "digiwincloud.com";

        String domainAppsYunA = "apps.digiwincloudlocal.com.cn";
        String domainYunA = "digiwincloudlocal.com.cn";

        String domainAppsYunB = "apps.digiwincloudlocal.com";
        String domainYunB = "digiwincloudlocal.com";

        JaProperty.getPropertyMap().forEach((k, v) -> {
            String value = v.toString();

            String replaceDomain = null;

            boolean isHttps = value.startsWith("https://");
            if (isHttps || value.startsWith("http://")) {
                if (value.contains(domainCNA)) {
                    replaceDomain = domainCNA;
                } else if (value.contains(domainCNB)) {
                    replaceDomain = domainCNB;
                } else if (value.contains(domainTWA)) {
                    replaceDomain = domainTWA;
                } else if (value.contains(domainTWB)) {
                    replaceDomain = domainTWB;
                } else if (value.contains(domainAppsYunA)) {
                    replaceDomain = domainAppsYunA;
                } else if (value.contains(domainYunA)) {
                    replaceDomain = domainYunA;
                } else if (value.contains(domainAppsYunB)) {
                    replaceDomain = domainAppsYunB;
                } else if (value.contains(domainYunB)) {
                    replaceDomain = domainYunB;
                }
                if (isHttps) {
                    value = value.replace("https", "http");
                    JaProperty.getPropertyMap().put(k, value);
                }
                if (null != replaceDomain) {
                    JaProperty.getPropertyMap().put(k, value.replace(replaceDomain, domainLocal));
                }
            }

        });

    }


    private void wrapRedisson() {
        String host = System.getenv().get("spring.redis.host");
        String password = System.getenv().get("spring.redis.password");
        String port = System.getenv().get("spring.redis.port");
        if (JaStringUtil.isSafeEmpty(host)) {
            return;
        }
        if (JaProperty.getPropertyMap().containsKey("redisson.address")) {
            String redissonAddress = String.format("%s:%s", host, port);
            JaLog.info("wrapRedisson : {}={}", "redisson.address", redissonAddress);
            JaProperty.getPropertyMap().put("redisson.address", redissonAddress);
        }
        if (JaProperty.getPropertyMap().containsKey("redisson.address")) {
            if (JaStringUtil.isSafeEmpty(password)) {
                password = "";
            }
            JaProperty.getPropertyMap().put("redisson.password", password);
            JaLog.info("wrapRedisson : {}={}", "redisson.password", password);
        }
    }
}
