package com.jugg.agile.biz.digiwin.esp;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.meta.JaReturn2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EspCacheProcessor {
//    public static JaFunctionRP2<MessageModel, HttpPost, String> CacheHandler
//
//    static {
//        // /restful/standard/mdc/ServiceBaseInfo/get
//        // /CROSS/RESTful/dpbas.sstest.plan.get
//
//        CacheHandlerList.add((messageModel, httpPost) -> {
//            String env = JaEnvProperty.getEnv();
//            if("huawei-pressure-pressure".equals(env)){
//
//            }
//        });
//    }

    public static Map<String, JaReturn2<String, Map<String, Object>>> TempCacheMap = new ConcurrentHashMap<>();

    public static JaReturn2<String, Map<String, Object>> getTempCache(String tTargetUrl) {
        if (!invokeTempCache(tTargetUrl)) {
            return null;
        }
        return TempCacheMap.get(tTargetUrl);
    }

    private static boolean invokeTempCache(String tTargetUrl) {
        String env = JaEnvProperty.getEnv();
        return "huawei-pressure-pressure".equals(env)
                && (
                tTargetUrl.contains("mdc/ServiceBaseInfo/get")
                        || tTargetUrl.contains("dpbas.sstest.plan.get")
                        || tTargetUrl.contains("dpbas.ssdandangprint.list.get")
        )
                ;
    }

    public static void setTempCache(String tTargetUrl, String resp, Map<String, Object> resHeaders) {
        if (!invokeTempCache(tTargetUrl)) {
            return;
        }
        TempCacheMap.put(tTargetUrl, new JaReturn2<>(resp, resHeaders));
    }
}
