/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DwMongoPropertyHandler
implements JaCenterPropertyHandler {
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml((String)"mongodb.yml", (String)JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
            String uri = JaProperty.get((String)"dw.mongodb.uri");
            Set keys = JaProperty.getPropertyMap().keySet();
            Set<String> mongoNameKey = keys.stream().filter(key -> key.startsWith("spring.data.mongodb")).map(key -> key.substring(0, key.lastIndexOf("."))).collect(Collectors.toSet());
            Map propertyMap = JaProperty.getPropertyMap();
            mongoNameKey.forEach(key -> {
                if (JaStringUtil.isSafeNotEmpty((String)uri)) {
                    JaLog.info((String)"wrapMongo uri: {}={}", (Object[])new Object[]{key + ".uri", uri});
                    propertyMap.putIfAbsent(key + ".uri", uri);
                }
            });
        }
        catch (Throwable e) {
            JaLog.error((String)"mongo nacos read error", (Object[])new Object[]{e});
        }
    }

    public int order() {
        return 10;
    }
}

