/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;
import java.util.Map;

public class DwRedisPropertyHandler
implements JaCenterPropertyHandler {
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml((String)"redis.yml", (String)JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
            String host = JaProperty.get((String)"dw.redis.host");
            Integer port = JaProperty.getInteger((String)"dw.redis.port");
            String password = JaProperty.get((String)"dw.redis.password");
            Map propertyMap = JaProperty.getPropertyMap();
            if (JaStringUtil.isSafeNotEmpty((String)host)) {
                JaLog.info((String)"wrapRedis host: {}={}", (Object[])new Object[]{"spring.redis.host", host});
                propertyMap.putIfAbsent("spring.redis.host", host);
            }
            if (port != null) {
                JaLog.info((String)"wrapRedis port: {}={}", (Object[])new Object[]{"spring.redis.port", port});
                propertyMap.putIfAbsent("spring.redis.port", port);
            }
            if (JaStringUtil.isSafeNotEmpty((String)password)) {
                JaLog.info((String)"wrapRedis password: {}={}", (Object[])new Object[]{"spring.redis.password", password});
                propertyMap.putIfAbsent("spring.redis.password", password);
            }
        }
        catch (Throwable e) {
            JaLog.error((String)"redis nacos read error", (Object[])new Object[]{e});
        }
    }

    public int order() {
        return 10;
    }
}

