package com.jugg.agile.biz.digiwin.config.biz;

import lombok.extern.slf4j.Slf4j;

/**
 * 服务的一些公共配置项
 * 服务域名等
 *
 * @author gengwei
 * @since 2024/11/1 16:47
 */
@Slf4j
public class DwBizConfig {

    /**
     * Aask 相关服务
     */
    public static class AaskDomainConfig {
        static String initDomainConfig(String group, String app) {
            return DwBizConfigProcessor.initDomainConfig("aask", group, app);
        }

        /**
         * 小ai相关服务
         */
        public static class Sai {
            static String initDomainConfig(String app) {
                return AaskDomainConfig.initDomainConfig("sai", app);
            }

            private static String abt;
            private static String audc;
            private static String im;
            private static String atmc;
            private static String uibot;
            private static String atdm;
            private static String aam;

            public static void init() {
                abt = initDomainConfig("abt");
                audc = Sai.initDomainConfig("audc");
                im = Sai.initDomainConfig("im");
                atmc = Sai.initDomainConfig("atmc");
                uibot = Sai.initDomainConfig("uibot");
                atdm = Sai.initDomainConfig("atdm");
                aam = Sai.initDomainConfig("aam");
            }

            public static String getAamUri() {
                return aam;
            }

            public static String getAtdmUri() {
                return atdm;
            }

            public static String getUibotUri() {
                return uibot;
            }

            public static String getAudcUri() {
                return audc;
            }

            public static String getImUri() {
                return im;
            }

            public static String getAbtUri() {
                return abt;
            }

        }
    }


}
