package com.jugg.agile.biz.digiwin.context.bm;

import com.jugg.agile.framework.core.context.JaMapContextLink;

import java.util.Map;

/**
 * 业务中台上下文处理
 *
 * @author chenjian
 * @since 2024年07月31日 15:11:12
 */
public class BMContextLink implements JaMapContextLink<BMContextEntity> {
    @Override
    public void inherit(Map<String, String> source, BMContextEntity target) {
        target.setIndustryTag(source.get(BMContextEntity.HeaderIndustryTag));

    }

    @Override
    public void transmit(BMContextEntity source, Map<String, String> target) {
        transmit(target, BMContextEntity.HeaderIndustryTag, source.getIndustryTag());
    }
}
