/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.context.ask.language;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class AcceptLanguageContextLink
implements JaMapContextLink<JaCoreContextEntity> {
    public static final String headerLocaleUp = "Locale";
    public static final String headerLocale = "locale";

    public void inherit(Map<String, String> source, JaCoreContextEntity context) {
        String language = this.getLanguage(source);
        if (JaStringUtil.isNotEmpty((String)language)) {
            Locale locale = JaI18nUtil.parseLocales((String)language);
            JaI18nUtil.LocaleThreadLocal.set((Object)locale);
            LocaleContextHolder.setLocale((Locale)locale);
        }
    }

    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        Locale locale = (Locale)JaI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            this.transmit(target, "accept-language", locale.toLanguageTag());
            this.transmit(target, headerLocale, locale.toString());
            this.transmit(target, "lang", locale.toString());
        }
    }

    public void remove() {
        JaI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }

    private String getLanguage(Map<String, String> source) {
        String acceptLanguage = source.get("accept-language");
        if (JaStringUtil.isEmpty((String)acceptLanguage)) {
            acceptLanguage = source.get("Accept-Language");
        }
        if (JaStringUtil.isNotEmpty((String)acceptLanguage)) {
            return acceptLanguage;
        }
        String locale = source.get(headerLocale);
        if (JaStringUtil.isEmpty((String)locale)) {
            locale = source.get(headerLocaleUp);
        }
        if (JaStringUtil.isNotEmpty((String)locale)) {
            return locale.replace('_', '-');
        }
        return null;
    }
}

