/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DwDatasourcePropertyHandler
implements JaCenterPropertyHandler {
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml((String)"mysql.yml", (String)JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
            String ip = JaProperty.get((String)"dw.datasource.ip");
            String port = JaProperty.get((String)"dw.datasource.port");
            String driverClassName = JaProperty.get((String)"dw.datasource.driverClassName");
            Set keys = JaProperty.getPropertyMap().keySet();
            Set<String> datasourceNameKey = keys.stream().filter(key -> key.startsWith("ja.datasource.pool")).filter(key -> key.endsWith("database")).map(key -> key.substring(0, key.lastIndexOf("."))).collect(Collectors.toSet());
            Map propertyMap = JaProperty.getPropertyMap();
            datasourceNameKey.forEach(key -> {
                if (JaStringUtil.isSafeNotEmpty((String)driverClassName)) {
                    JaLog.info((String)"wrapMysql driverClassName: {}={}", (Object[])new Object[]{key + ".driverClassName", driverClassName});
                    propertyMap.putIfAbsent(key + ".driverClassName", driverClassName);
                }
                if (JaStringUtil.isSafeNotEmpty((String)ip)) {
                    JaLog.info((String)"wrapMysql ip: {}={}", (Object[])new Object[]{key + ".ip", ip});
                    propertyMap.putIfAbsent(key + ".ip", ip);
                }
                if (JaStringUtil.isSafeNotEmpty((String)port)) {
                    JaLog.info((String)"wrapMysql port: {}={}", (Object[])new Object[]{key + ".port", port});
                    propertyMap.putIfAbsent(key + ".port", port);
                }
            });
        }
        catch (Throwable e) {
            JaLog.error((String)"mysql nacos read error", (Object[])new Object[]{e});
        }
    }

    public int order() {
        return 10;
    }
}

