/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.biz.digiwin.config.common.post;

import com.digiwin.athena.framework.core.config.env.DwOPSEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class DwPrivateDeploymentPostPropertyHandler
implements JaPostPropertyHandler {
    private Set<String> atmcMongoKey = new HashSet<String>();
    private Set<String> atmcRedisKey = new HashSet<String>();

    public DwPrivateDeploymentPostPropertyHandler() {
        this.atmcMongoKey.add("spring.data.ptmprimary.uri");
        this.atmcMongoKey.add("spring.data.ptmlog.uri");
        this.atmcMongoKey.add("spring.data.ptmslave.uri");
        this.atmcMongoKey.add("spring.data.ptmddsm.uri");
        this.atmcMongoKey.add("dataComparison.mongo.uri");
        this.atmcMongoKey.add("datafootprint.mongo.uri");
        this.atmcRedisKey.add("athena.redis.ptm.password");
        this.atmcRedisKey.add("athena.redis.ptm.host");
        this.atmcRedisKey.add("athena.redis.ptm.port");
    }

    public void addAndCover() {
        if (DwOPSEnvPropertyHandler.getIsLocal()) {
            if (DwPrivateDeploymentPostPropertyHandler.appNoNeedCoverConfig()) {
                return;
            }
            this.wrapNacosDiscovery();
            this.wrapMysql();
            this.wrapDomain();
            this.wrapMongodb();
            this.wrapRedis();
            this.wrapRedisson();
            this.wrapMq();
        }
    }

    private static boolean appNoNeedCoverConfig() {
        String appName = Optional.ofNullable(JaEnvProperty.getEntity()).map(JaEnvProperty.Entity::getApplicationName).orElse("");
        return "aim".equals(appName);
    }

    private void wrapMq() {
        JaProperty.getPropertyMap().put("spring.rabbitmq.outhost", "");
        Object rabbitUri = JaProperty.getPropertyMap().get("spring.rabbitmq.addresses");
        JaLog.info((String)"rabbitUri={}", (Object[])new Object[]{rabbitUri});
        JaProperty.getPropertyMap().put("rabbit.mquri", rabbitUri);
        JaProperty.getPropertyMap().put("athena.mq.monitor.enable", false);
    }

    private void wrapRedis() {
        String host = System.getenv().get("spring.redis.host");
        String password = System.getenv().get("spring.redis.password");
        String port = System.getenv().get("spring.redis.port");
        if (JaStringUtil.isSafeEmpty((String)host)) {
            return;
        }
        JaEnvProperty.Entity entity = JaEnvProperty.getEntity();
        String applicationName = entity.getApplicationName();
        if ("atmc".equals(applicationName) || "datacomparison".equals(applicationName) || "datafootprint".equals(applicationName) || "ptm".equals(applicationName)) {
            Set keys = JaProperty.getPropertyMap().keySet();
            keys.forEach(key -> {
                if ("athena.redis.ptm.password".equals(key)) {
                    JaLog.info((String)"wrapRedis : {}={}", (Object[])new Object[]{key, password});
                    JaProperty.getPropertyMap().put(key, password);
                }
                if ("athena.redis.ptm.host".equals(key)) {
                    JaLog.info((String)"wrapRedis : {}={}", (Object[])new Object[]{key, host});
                    JaProperty.getPropertyMap().put(key, host);
                }
                if ("athena.redis.ptm.port".equals(key)) {
                    JaLog.info((String)"wrapRedis : {}={}", (Object[])new Object[]{key, port});
                    JaProperty.getPropertyMap().put(key, port);
                }
            });
        }
    }

    public int order() {
        return 10;
    }

    private void wrapNacosDiscovery() {
        JaProperty.getPropertyMap().put("dwdiscoveryServer", System.getenv().get("spring.cloud.nacos.discovery.server-addr"));
    }

    private void wrapMysql() {
        String host = System.getenv().get("custom.datasource.host");
        if (JaStringUtil.isSafeEmpty((String)host)) {
            return;
        }
        String port = System.getenv().get("custom.datasource.port");
        Set keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            boolean isDatasourceKey = key.startsWith("spring.datasource.");
            if (isDatasourceKey) {
                String datasourcePassword;
                String datasourceUsername;
                if (key.endsWith(".url")) {
                    String oldJdbcUrl = JaProperty.get((String)key);
                    int i = oldJdbcUrl.indexOf("//") + 2;
                    int i1 = oldJdbcUrl.indexOf("?");
                    String substring = oldJdbcUrl.substring(i, i1);
                    String database = substring.split("/")[1];
                    String jdbcUrl = String.format("jdbc:mysql://%s:%s/%s?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true", host, port, database);
                    JaProperty.getPropertyMap().put("spring.datasource.driver-class-name", "com.mysql.cj.jdbc.Driver");
                    JaLog.info((String)"wrapMysql : {}={}", (Object[])new Object[]{key, jdbcUrl});
                    JaProperty.getPropertyMap().put(key, jdbcUrl);
                }
                if (key.endsWith(".username") && JaStringUtil.isSafeNotEmpty((String)(datasourceUsername = JaProperty.get((String)"spring.datasource.username")))) {
                    JaLog.info((String)"wrapMysql username: {}={}", (Object[])new Object[]{key, datasourceUsername});
                    JaProperty.getPropertyMap().put(key, datasourceUsername);
                }
                if (key.endsWith(".password") && JaStringUtil.isSafeNotEmpty((String)(datasourcePassword = JaProperty.get((String)"spring.datasource.password")))) {
                    JaLog.info((String)"wrapMysql password: {}={}", (Object[])new Object[]{key, datasourcePassword});
                    JaProperty.getPropertyMap().put(key, datasourcePassword);
                }
            }
        });
    }

    public static void main(String[] args) {
        System.out.println("digiwincloudlocal.com.cn/".replace("digiwincloudlocal.com.cn", "xxxxx"));
        String oldJdbcUrl = "jdbc:mysql://digiwincloud-prod-athena.mariadb.database.azure.com/athena_im?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true";
        int i = oldJdbcUrl.indexOf("//") + 2;
        int i1 = oldJdbcUrl.indexOf("?");
        String substring = oldJdbcUrl.substring(i, i1);
        String database = substring.split("/")[1];
        String jdbcUrl = String.format("jdbc:mariadb://%s:%s/%s?serverTimezone=Asia/Shanghai&useUnicode=true&characterEncoding=utf-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true", "host", "port", database);
        System.out.println(jdbcUrl);
    }

    private void wrapMongodb() {
        String cluster = System.getenv().get("custom.data.mongodb.cluster");
        if (JaStringUtil.isSafeEmpty((String)cluster)) {
            return;
        }
        String username = System.getenv().get("spring.data.mongodb.username");
        String password = System.getenv().get("spring.data.mongodb.password");
        String mongoUri = String.format("mongodb://%s:%s@%s", username, password, cluster);
        JaEnvProperty.Entity entity = JaEnvProperty.getEntity();
        Set keys = JaProperty.getPropertyMap().keySet();
        keys.forEach(key -> {
            String applicationName;
            if (key.startsWith("spring.data.") && key.contains("mongodb") && key.endsWith(".uri")) {
                JaLog.info((String)"wrapMongodb : {}={}", (Object[])new Object[]{key, mongoUri});
                JaProperty.getPropertyMap().put(key, mongoUri);
            }
            if (("atmc".equals(applicationName = entity.getApplicationName()) || "datacomparison".equals(applicationName) || "datafootprint".equals(applicationName) || "ptm".equals(applicationName)) && this.atmcMongoKey.contains(key)) {
                JaLog.info((String)"wrapMongodb : {}={}", (Object[])new Object[]{key, mongoUri});
                JaProperty.getPropertyMap().put(key, mongoUri);
            }
        });
    }

    private void wrapDomain() {
        String domainLocal = System.getenv().get("custom.domain");
        if (JaStringUtil.isSafeEmpty((String)domainLocal)) {
            return;
        }
        String domainCNA = "apps.digiwincloud.com.cn";
        String domainCNB = "digiwincloud.com.cn";
        String domainTWA = "apps.digiwincloud.com";
        String domainTWB = "digiwincloud.com";
        String domainAppsYunA = "apps.digiwincloudlocal.com.cn";
        String domainYunA = "digiwincloudlocal.com.cn";
        String domainAppsYunB = "apps.digiwincloudlocal.com";
        String domainYunB = "digiwincloudlocal.com";
        JaProperty.getPropertyMap().forEach((k, v) -> {
            String value = v.toString();
            String replaceDomain = null;
            boolean isHttps = value.startsWith("https://");
            if (isHttps || value.startsWith("http://")) {
                if (value.contains(domainCNA)) {
                    replaceDomain = domainCNA;
                } else if (value.contains(domainCNB)) {
                    replaceDomain = domainCNB;
                } else if (value.contains(domainTWA)) {
                    replaceDomain = domainTWA;
                } else if (value.contains(domainTWB)) {
                    replaceDomain = domainTWB;
                } else if (value.contains(domainAppsYunA)) {
                    replaceDomain = domainAppsYunA;
                } else if (value.contains(domainYunA)) {
                    replaceDomain = domainYunA;
                } else if (value.contains(domainAppsYunB)) {
                    replaceDomain = domainAppsYunB;
                } else if (value.contains(domainYunB)) {
                    replaceDomain = domainYunB;
                }
                if (isHttps) {
                    value = value.replace("https", "http");
                    JaProperty.getPropertyMap().put(k, value);
                }
                if (null != replaceDomain) {
                    JaProperty.getPropertyMap().put(k, value.replace(replaceDomain, domainLocal));
                }
            }
        });
    }

    private void wrapRedisson() {
        String host = System.getenv().get("spring.redis.host");
        String password = System.getenv().get("spring.redis.password");
        String port = System.getenv().get("spring.redis.port");
        if (JaStringUtil.isSafeEmpty((String)host)) {
            return;
        }
        if (JaProperty.getPropertyMap().containsKey("redisson.address")) {
            String redissonAddress = String.format("%s:%s", host, port);
            JaLog.info((String)"wrapRedisson : {}={}", (Object[])new Object[]{"redisson.address", redissonAddress});
            JaProperty.getPropertyMap().put("redisson.address", redissonAddress);
        }
        if (JaProperty.getPropertyMap().containsKey("redisson.address")) {
            if (JaStringUtil.isSafeEmpty((String)password)) {
                password = "";
            }
            JaProperty.getPropertyMap().put("redisson.password", password);
            JaLog.info((String)"wrapRedisson : {}={}", (Object[])new Object[]{"redisson.password", password});
        }
    }
}

