package com.jugg.agile.biz.digiwin.esp.meta.message;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 发送给告警平台的消息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class EspAlarmMessage {

    /**
     * 来源应用ID
     */
    private String appId;

    private LocalDateTime createdTime = LocalDateTime.now();

    /**
     * 自定义内容
     */
    private Object custom;

    /**
     * 运营单元
     */
    private Object eocId;

    private String errorCode;

    /**
     * 异常描述
     */
    private String exception;

    private String pinpointId;

    private String tenantId;

    /**
     * 是否是异常
     */
    private Integer isError = 1;

}
