package com.jugg.agile.biz.digiwin.context.bm;

import com.jugg.agile.framework.core.context.JaContext;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;

/**
 * 业务中台上下文
 *
 * @author chenjian
 * @since 2024年07月30日 14:31:17
 */
public class BMContext extends JaContext<BMContextEntity> {
    private static final JaThreadLocal<BMContextEntity> jaThreadLocal = new JaThreadLocal<>();
    private static final BMContext instance = new BMContext();

    public static BMContext getInstance() {
        return instance;
    }

    @Override
    public BMContextEntity set(BMContextEntity context) {
        jaThreadLocal.set(context);
        return context;
    }

    @Override
    public BMContextEntity get() {
        return jaThreadLocal.get();
    }

    @Override
    public void remove() {
        jaThreadLocal.remove();
    }
}
