package com.jugg.agile.biz.digiwin.config.common.center;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 抽取mysql的公共配置，ip，port，driverClassName 等
 *
 * @author gengwei
 * @since 2024/12/10 10:09
 */
public class DwDatasourcePropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("mysql.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            }
            String ip = JaProperty.get("dw.datasource.ip");
            String port = JaProperty.get("dw.datasource.port");
            String driverClassName = JaProperty.get("dw.datasource.driverClassName");
            Set<String> keys = JaProperty.getPropertyMap().keySet();
            // ja.datasource.pool.xxxx
            Set<String> datasourceNameKey = keys.stream()
                    .filter(key -> key.startsWith("ja.datasource.pool"))
                    .filter(key -> key.endsWith("database"))
                    .map(key -> key.substring(0, key.lastIndexOf(".")))
                    .collect(Collectors.toSet());

            Map<String, Object> propertyMap = JaProperty.getPropertyMap();
            datasourceNameKey.forEach(key -> {
                // dw.datasource.driverClassName 赋值给 ja.datasource.pool.xxxx.driverClassName
                if (JaStringUtil.isSafeNotEmpty(driverClassName)) {
                    JaLog.info("wrapMysql driverClassName: {}={}", key + ".driverClassName", driverClassName);
                    propertyMap.putIfAbsent(key + ".driverClassName", driverClassName);
                }
                // dw.datasource.ip 赋值给 ja.datasource.pool.xxxx.ip
                if (JaStringUtil.isSafeNotEmpty(ip)) {
                    JaLog.info("wrapMysql ip: {}={}", key + ".ip", ip);
                    propertyMap.putIfAbsent(key + ".ip", ip);

                }
                // dw.datasource.port 赋值给 ja.datasource.pool.xxxx.port
                if (JaStringUtil.isSafeNotEmpty(port)) {
                    JaLog.info("wrapMysql port: {}={}", key + ".port", port);
                    propertyMap.putIfAbsent(key + ".port", port);
                }
            });
        } catch (Throwable e) {
            JaLog.error("mysql nacos read error", e);
        }

    }

    @Override
    public int order() {
        return 10;
    }
}
