package com.digiwin.athena.framework.iam.config;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

public class DwIamConfigPostPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("biz-dap-iam.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());

            }
        } catch (Throwable e) {
            JaLog.error("iam config load error", e);
        }
    }

    /**
     * 先与应用加载。 应用自己配置，可以覆盖（以应用为准）
     */
    @Override
    public int order() {
        return -10;
    }
}
