package com.digiwin.athena.framework.dap.loadbalance.config;

import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.constants.JaConfigKeyConstants;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

/**
 * dap去中心化, 地址适配ja nacos 配置
 *
 * @author chenjian
 * @since 2025年04月25日 13:19:20
 */
public class DwLoadbalancePostPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            JaProperty.getPropertyMap().put("spring.cloud.compatibility-verifier.enabled", "false");
            JaNacosConfigService.loadYaml("loadbalance.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
            Boolean dwloadBalanceEnable = JaProperty.getBoolean("dwloadBalanceEnable", true);
            JaProperty.getPropertyMap().put("dwloadBalanceEnable", dwloadBalanceEnable);
            if (Boolean.TRUE.equals(dwloadBalanceEnable)) {
                JaProperty.getPropertyMap().put("dwhttpClient.loadbalance.mode", "auto");
                String dwdiscoveryServer = JaProperty.get("dwdiscoveryServer");
                String serverAddr = JaProperty.get(JaConfigKeyConstants.Nacos.ServerAddr);
                if (JaStringUtil.isSafeEmpty(dwdiscoveryServer) && JaStringUtil.isNotEmpty(serverAddr)) {
                    JaProperty.getPropertyMap().put("dwdiscoveryServer", serverAddr);
                }
            }
        } catch (Throwable e) {
            JaLog.error("DwLoadbalancePrePropertyHandler config load error", e);
        }
    }

    @Override
    public int order() {
        return 10;
    }
}
