package com.digiwin.athena.framework.dap.dapper;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRestfulService;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.JaSpiUtil;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartRequest;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.util.ArrayList;
import java.util.Set;

@Component
public class DapNodeSpanWeb implements JaNodeSpanResolver, JaDapperAspectPointcut {

    private static final NodeKind webNodeKind = new NodeKind("web", true)
            .buildReqArgsHandler(args -> {
                if (JaCollectionUtil.isEmpty(args)) {
                    return args;
                }
                ArrayList<Object> objects = new ArrayList<>(args.length);
                for (Object arg : args) {
                    if (arg instanceof ServletRequest
                            || arg instanceof ServletResponse
                            || arg instanceof MultipartRequest
                    ) {
                        continue;
                    }
                    objects.add(arg);
                }
                return objects.toArray();
            });

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {

//        DWTargetAPI api = (DWTargetAPI)httpRequest.getAttribute("targetAPI");
//        DWParameters apiParameters = (DWParameters)httpRequest.getAttribute("targetParameters");


        // com.digiwin.app.service.restful.DWRestfulService

        if (null != JaAopUtil.getClassAnnotation(invocation, DWRestfulService.class)) {
            return get(webNodeKind);
        }
        if (invocation.getThis() instanceof DWService) {
            return get(webNodeKind);
        }
        return null;
    }

    @Override
    public String getExpression() {
        Set<String> customBasePackageSet = JaSpiUtil.getCustomBasePackageSet();
        StringBuilder expressionBuilder = new StringBuilder();
        for (String s : customBasePackageSet) {
            expressionBuilder.append(String.format("(execution(* %s..*.*(..)) && target(com.digiwin.app.service.DWService)) || ", s));
        }
        expressionBuilder.append("@within(com.digiwin.app.service.restful.DWRestfulService)");
        return expressionBuilder.toString();
    }
}
