/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.dap.config;

import com.digiwin.app.common.DWPropertiesUtils;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.meta.function.JaFunctionP2;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;

public class DapPlatformBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    public void postProcessBeanFactory(@Nullable ConfigurableListableBeanFactory beanFactory) throws BeansException {
        JaLog.info((String)"DapPlatformBeanFactoryPostProcessor----------starter", (Object[])new Object[0]);
        Map propertyMap = JaProperty.getPropertyMap();
        Map<String, String> env = System.getenv();
        HashMap<String, Object> merge = new HashMap<String, Object>();
        merge.putAll(env);
        merge.putAll(propertyMap);
        this.initJvmEnvHandler();
        merge.forEach((k, v) -> {
            if (env.containsKey(k)) {
                try {
                    JaEnvProperty.put((String)k, (String)v.toString());
                }
                catch (Throwable e) {
                    JaLog.error((String)"JaEnvProperty.put error:[k : {}, v : {}]", (Object[])new Object[]{k, v + "", e});
                    throw e;
                }
            }
        });
        JaProperty.getPropertyMap().putAll(merge);
        Properties dapProperties = new Properties();
        JaProperty.getPropertyMap().forEach((key, value) -> dapProperties.put(key, value.toString()));
        MutablePropertySources propertySources = JaSpringBootUtil.getEnvironment().getPropertySources();
        propertySources.addFirst((PropertySource)new PropertiesPropertySource("dapProperties", dapProperties));
        this.store(dapProperties);
        this.proxy(dapProperties);
    }

    private void store(Properties localProps) {
        String filePath = "platform.properties";
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            localProps.store(writer, "jugg");
        }
    }

    private void proxy(Properties dapProperties) {
        Object pool = JaReflectUtil.getFieldValue(DWPropertiesUtils.class, (String)"pool");
        Object poolProxy = JaSpringAopUtil.getProxy((Object)pool, invocation -> {
            Object[] arguments = invocation.getArguments();
            if (invocation.getMethod().getName().equals("getProperties") && arguments.length == 2) {
                return dapProperties;
            }
            return invocation.proceed();
        });
        JaReflectUtil.setFieldValue(DWPropertiesUtils.class, (String)"pool", (Object)poolProxy);
    }

    private void initJvmEnvHandler() {
        String version = System.getProperty("java.version");
        if (version.equals("1.8.0_372")) {
            JaEnvProperty.setJvmEnvHandler((JaFunctionP2)new JaFunctionP2<String, String>(){
                private Map<String, String> theUnmodifiableEnvironment = null;

                public void apply(String k, String v) {
                    if (null == this.theUnmodifiableEnvironment) {
                        this.theUnmodifiableEnvironment = (Map)JaReflectUtil.getFieldValue(System.getenv(), (String)"m");
                    }
                    this.theUnmodifiableEnvironment.put(k, v);
                }
            });
        }
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.version"));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

