package com.digiwin.athena.framework.dap.config;

import com.digiwin.athena.framework.apollo.config.DwApolloPostPropertyHandler;
import com.digiwin.athena.framework.core.config.env.DwOPSEnvPropertyHandler;
import com.digiwin.athena.framework.core.config.pre.DwNacosConfigPrePropertyHandler;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class DwSpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public DwSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
        // 容错dap框架配置
        new DwOPSEnvPropertyHandler().addAndCover();
        new DwNacosConfigPrePropertyHandler().addAndCover();
        new DwApolloPostPropertyHandler().addAndCover();
    }


    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context) {
    }

    @Override
    public void running(ConfigurableApplicationContext context) {
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    @Override
    public int getOrder() {
        return -10;
    }
}