package com.digiwin.athena.framework.dap.config;

import com.digiwin.app.common.DWPropertiesUtils;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.reflect.JaReflectUtil;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import lombok.SneakyThrows;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.lang.Nullable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * dap框架项目 jugg配置优先级最高
 *
 * @author chenjian
 * @since 2025年05月28日 10:36:34
 */
public class DapPlatformBeanFactoryPostProcessor implements BeanFactoryPostProcessor, Ordered {

    @Override
    public void postProcessBeanFactory(@Nullable ConfigurableListableBeanFactory beanFactory) throws BeansException {
        JaLog.info("DapPlatformBeanFactoryPostProcessor----------starter");
        // nacos
        Map<String, Object> propertyMap = JaProperty.getPropertyMap();
        // 环境变量
        Map<String, String> env = System.getenv();
        Map<String, Object> merge = new HashMap<>();
        merge.putAll(env);
        merge.putAll(propertyMap);
        // nacos 覆盖 env
        merge.forEach((k, v) -> {
            if (env.containsKey(k)) {
                try {
                    JaEnvProperty.put(k, v.toString());
                } catch (Throwable e) {
                    JaLog.error("JaEnvProperty.put error:[k : {}, v : {}]", k, v + "", e);
                    throw e;
                }
            }
        });

        // nacos + env
        JaProperty.getPropertyMap().putAll(merge);

        // nacos + env 交给 spring 并且优先级最高
        Properties dapProperties = new Properties();
        JaProperty.getPropertyMap().forEach((key, value) -> dapProperties.put(key, value.toString()));
        MutablePropertySources propertySources = JaSpringBootUtil.getEnvironment().getPropertySources();
        propertySources.addFirst(new PropertiesPropertySource("dapProperties", dapProperties));


        store(dapProperties);

        proxy(dapProperties);
    }

    @SneakyThrows
    private void store(Properties localProps) {
        String filePath = "platform.properties";
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }

        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file), StandardCharsets.UTF_8)) {
            localProps.store(writer, "jugg");
        }
    }

    private void proxy(Properties dapProperties) {
        Object pool = JaReflectUtil.getFieldValue(DWPropertiesUtils.class, "pool");
        Object poolProxy = JaSpringAopUtil.getProxy(pool, invocation -> {
            Object[] arguments = invocation.getArguments();
            if (invocation.getMethod().getName().equals("getProperties") && arguments.length == 2) {
                return dapProperties;
            }
            return invocation.proceed();
        });
        JaReflectUtil.setFieldValue(DWPropertiesUtils.class, "pool", poolProxy);
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.version"));
    }


    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}
