package com.digiwin.athena.framework.dap.config;


import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * Alor 2025/9/19
 * DapLogReconfigurePostProcessor 的order要小于JaEnvironmentPostProcessor的order
 **/
public class DapLogReconfigurePostProcessor implements EnvironmentPostProcessor, Ordered {
    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment,
                                       SpringApplication application) {
        Boolean reconfigure = JaProperty.getBoolean("ja.dap.log.reconfigure", true);
        if (reconfigure) {
            LoggerContext context = (LoggerContext) LogManager.getContext(false);
            context.reconfigure();
            JaLog.info("----->:DapLogReconfigurePostProcessor 重新刷新日志上下文");
        }
    }

    @Override
    public int getOrder() {
        return -1;
    }
}
