/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.dispatch;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.framework.dispatch.LocalControllerMatcher;
import com.digiwin.athena.framework.dispatch.RestLocalProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class LocalDispatcherInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LocalDispatcherInterceptor.class);
    private final DispatcherServlet dispatcherServlet;
    private final LocalControllerMatcher matcher;
    private final WebApplicationContext context;
    private final RestLocalProperties properties;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private static final String LOCAL_CALL_HEADER = "digi-local-call";

    public LocalDispatcherInterceptor(WebApplicationContext context, RequestMappingHandlerMapping mapping, DispatcherServlet dispatcherServlet, RestLocalProperties properties) {
        this.context = context;
        this.dispatcherServlet = dispatcherServlet;
        this.matcher = new LocalControllerMatcher(mapping);
        this.properties = properties;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String path = request.getURI().getPath();
        HttpMethod method = request.getMethod();
        if (!this.properties.isEnabled() || request.getHeaders().containsKey((Object)LOCAL_CALL_HEADER) || this.isExcludedPath(path)) {
            return execution.execute(request, body);
        }
        if (this.matcher.matches(path, method)) {
            log.info("LocalDispatcherInterceptor url:{},\u8d70\u672c\u5730", (Object)path);
            return this.forwardLocally(request, body);
        }
        log.info("LocalDispatcherInterceptor url:{},\u8d70\u8fdc\u7a0b", (Object)path);
        return execution.execute(request, body);
    }

    private boolean isExcludedPath(String path) {
        if (this.properties.getExcludes() == null) {
            return false;
        }
        return this.properties.getExcludes().stream().anyMatch(pattern -> this.pathMatcher.match(pattern, path));
    }

    private ClientHttpResponse forwardLocally(HttpRequest request, byte[] body) throws IOException {
        MockHttpServletRequest servletRequest = new MockHttpServletRequest(this.context.getServletContext());
        servletRequest.setMethod(request.getMethod().name());
        servletRequest.setRequestURI(request.getURI().getPath());
        servletRequest.setContent(body);
        servletRequest.addHeader(LOCAL_CALL_HEADER, (Object)"true");
        String query = request.getURI().getRawQuery();
        if (query != null) {
            for (String pair : query.split("&")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) continue;
                servletRequest.addParameter(URLDecoder.decode(kv[0], "UTF-8"), URLDecoder.decode(kv[1], "UTF-8"));
            }
        }
        request.getHeaders().forEach((key, values) -> values.forEach(value -> servletRequest.addHeader(key, value)));
        servletRequest.setAttribute("digi-middleware-auth-user-data", (Object)AppAuthContextHolder.getContext().getAuthoredUser());
        servletRequest.setAttribute("digi-middleware-proxy-auth-user-data", (Object)AppAuthContextHolder.getContext().getProxyAuthoredUser());
        final MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        try {
            this.dispatcherServlet.service((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (Exception e) {
            throw new IOException("Local dispatch failed: " + request.getURI(), e);
        }
        return new ClientHttpResponse(){

            public HttpStatus getStatusCode() {
                return HttpStatus.valueOf((int)servletResponse.getStatus());
            }

            public int getRawStatusCode() {
                return servletResponse.getStatus();
            }

            public String getStatusText() {
                return Optional.ofNullable(servletResponse.getErrorMessage()).orElse("");
            }

            public void close() {
            }

            public InputStream getBody() {
                return new ByteArrayInputStream(servletResponse.getContentAsByteArray());
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                for (String name : servletResponse.getHeaderNames()) {
                    headers.put(name, new ArrayList(servletResponse.getHeaders(name)));
                }
                return headers;
            }
        };
    }
}

