package com.digiwin.athena.framework.dispatch;

import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.Map;
import java.util.Set;

public class LocalControllerMatcher {

    private final RequestMappingHandlerMapping handlerMapping;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public LocalControllerMatcher(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    public boolean matches(String path, HttpMethod httpMethod) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMapping.getHandlerMethods().entrySet()) {
            RequestMappingInfo info = entry.getKey();
            Set<String> patterns = info.getPatternsCondition().getPatterns();
            Set<RequestMethod> methods = info.getMethodsCondition().getMethods();
            boolean methodMatch = methods.isEmpty() || methods.contains(RequestMethod.valueOf(httpMethod.name()));
            boolean pathMatch = patterns.stream().anyMatch(pattern -> pathMatcher.match(pattern, path));
            if (methodMatch && pathMatch) {
                return true;
            }
        }
        return false;
    }
}