package com.digiwin.athena.framework.dispatch;

import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Data
@Configuration
@ConditionalOnProperty(prefix = "athena.dispatch", name = "enable", havingValue = "true")
@ConfigurationProperties(prefix = "athena.dispatch")
public class RestLocalProperties {

    private boolean enabled = true;

    private List<String> excludes;

}