package com.digiwin.athena.framework.dispatch;

import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;

import java.util.Objects;

public class HttpHeaderUtils {

    /**
     * 拷贝 HttpRequest 的 headers 到 MockHttpServletRequest
     * 自动把 null 转成 "" 避免 Header value must not be null
     */
    public static void copyHeaders(HttpHeaders headers, MockHttpServletRequest servletRequest) {
        headers.forEach((key, values) -> {
            for (String value : values) {
                // null 转成 ""，避免 MockHttpServletRequest 抛错
                servletRequest.addHeader(key, Objects.toString(value, ""));
            }
        });
    }
}