package com.digiwin.athena.framework.dispatch;

import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

@Slf4j
public class LocalDispatcherConfigUpdater implements InitializingBean {

    private final RestLocalProperties configurer;

    public LocalDispatcherConfigUpdater(RestLocalProperties configurer) {
        this.configurer = configurer;
    }

    public void nacosUpdate() {
        JaPropertyListener.addCommonListener(() -> {
            JaSpringPropertyProcessor.refresh(RestLocalProperties.class);
        });
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        nacosUpdate();
    }
}
