/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.dispatch;

import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class LocalControllerMatcher {
    private final RequestMappingHandlerMapping handlerMapping;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public LocalControllerMatcher(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    public boolean matches(String path, HttpMethod httpMethod) {
        for (Map.Entry entry : this.handlerMapping.getHandlerMethods().entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)entry.getKey();
            Set patterns = info.getPatternsCondition().getPatterns();
            Set methods = info.getMethodsCondition().getMethods();
            boolean methodMatch = methods.isEmpty() || methods.contains(RequestMethod.valueOf((String)httpMethod.name()));
            boolean pathMatch = patterns.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, path));
            if (!methodMatch || !pathMatch) continue;
            return true;
        }
        return false;
    }
}

