package com.digiwin.athena.framework.dispatch;

import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class LocalControllerMatcher {

    private final RequestMappingHandlerMapping handlerMapping;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public LocalControllerMatcher(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    public boolean matches(String path, HttpMethod httpMethod) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMapping.getHandlerMethods().entrySet()) {
            RequestMappingInfo info = entry.getKey();
            // 1. 获取路径
            Set<String> antPatterns = Collections.emptySet();
            Set<PathPattern> pathPatterns = Collections.emptySet();
            if (info.getPatternsCondition() != null) {
                antPatterns = info.getPatternsCondition().getPatterns();
            }
            if (info.getPathPatternsCondition() != null) {
                pathPatterns = info.getPathPatternsCondition().getPatterns();
            }
            // 2. 获取方法
            Set<RequestMethod> methods = info.getMethodsCondition().getMethods();
            boolean methodMatch = methods.isEmpty() || methods.contains(RequestMethod.valueOf(httpMethod.name()));
            // 3. 路径匹配
            boolean pathMatch = false;

            // AntPathMatcher 模式
            if (!antPatterns.isEmpty()) {
                pathMatch = antPatterns.stream().anyMatch(pattern -> pathMatcher.match(pattern, path));
            }
            // PathPatternParser 模式
            if (!pathPatterns.isEmpty()) {
                pathMatch = pathPatterns.stream().anyMatch(pattern -> pattern.matches(PathContainer.parsePath(path)));
            }
            if (methodMatch && pathMatch) {
                return true;
            }
        }
        return false;
    }

}