/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.dispatch;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class LocalControllerMatcher {
    private final RequestMappingHandlerMapping handlerMapping;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public LocalControllerMatcher(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    public boolean matches(String path, HttpMethod httpMethod) {
        for (Map.Entry entry : this.handlerMapping.getHandlerMethods().entrySet()) {
            Set methods;
            RequestMappingInfo info = (RequestMappingInfo)entry.getKey();
            Set antPatterns = Collections.emptySet();
            Set pathPatterns = Collections.emptySet();
            if (info.getPatternsCondition() != null) {
                antPatterns = info.getPatternsCondition().getPatterns();
            }
            if (info.getPathPatternsCondition() != null) {
                pathPatterns = info.getPathPatternsCondition().getPatterns();
            }
            boolean methodMatch = (methods = info.getMethodsCondition().getMethods()).isEmpty() || methods.contains(RequestMethod.valueOf((String)httpMethod.name()));
            boolean pathMatch = false;
            if (!antPatterns.isEmpty()) {
                pathMatch = antPatterns.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, path));
            }
            if (!pathPatterns.isEmpty()) {
                pathMatch = pathPatterns.stream().anyMatch(pattern -> pattern.matches(PathContainer.parsePath((String)path)));
            }
            if (!methodMatch || !pathMatch) continue;
            return true;
        }
        return false;
    }
}

